/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions.entity;

import io.netty.util.internal.StringUtil;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class RandomChance
extends Condition.EntityPatchCondition {
    private double chance;

    public RandomChance() {
        this.chance = 0.0;
    }

    public RandomChance(double chance) {
        this.chance = chance;
    }

    public RandomChance read(CompoundTag tag) {
        this.chance = this.assertTag("chance", "decimal", tag, NumericTag.class, CompoundTag::getDouble);
        return this;
    }

    @Override
    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("chance", this.chance);
        return tag;
    }

    @Override
    public boolean predicate(LivingEntityPatch<?> target) {
        return ((LivingEntity)target.getOriginal()).getRandom().nextDouble() < this.chance;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        ResizableEditBox editbox = new ResizableEditBox(screen.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"chance"), null, null);
        editbox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
        return List.of(Condition.ParameterEditor.of(value -> (Tag)ParseUtil.parseOrGet(value.toString(), v -> DoubleTag.valueOf((double)Double.parseDouble(value.toString())), StringTag.valueOf((String)"")), tag -> ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(tag, Tag::getAsString)), (AbstractWidget)editbox));
    }
}

