/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions.entity;

import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TargetInDistance
extends Condition.EntityPatchCondition {
    private double min;
    private double max;

    public TargetInDistance() {
    }

    public TargetInDistance(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public TargetInDistance read(CompoundTag tag) {
        this.min = this.assertTag("min", "decimal", tag, NumericTag.class, CompoundTag::getDouble);
        this.max = this.assertTag("max", "decimal", tag, NumericTag.class, CompoundTag::getDouble);
        return this;
    }

    @Override
    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("min", this.min);
        tag.putDouble("max", this.max);
        return tag;
    }

    @Override
    public boolean predicate(LivingEntityPatch<?> target) {
        double distanceSqr = ((LivingEntity)target.getOriginal()).distanceToSqr((Entity)target.getTarget());
        return this.min * this.min < distanceSqr && distanceSqr < this.max * this.max;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        ResizableEditBox minEditBox = new ResizableEditBox(screen.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"min"), null, null);
        ResizableEditBox maxEditBox = new ResizableEditBox(screen.getMinecraft().font, 0, 0, 0, 0, (Component)Component.literal((String)"max"), null, null);
        minEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
        maxEditBox.setFilter(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
        Function<Object, Tag> doubleParser = value -> DoubleTag.valueOf((double)Double.valueOf(value.toString()));
        Function<Tag, Object> doubleGetter = tag -> ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(tag, Tag::getAsString));
        return List.of(Condition.ParameterEditor.of(doubleParser, doubleGetter, (AbstractWidget)minEditBox), Condition.ParameterEditor.of(doubleParser, doubleGetter, (AbstractWidget)maxEditBox));
    }
}

