/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPClearSkills;
import yesman.epicfight.network.server.SPRemoveSkillAndLearn;
import yesman.epicfight.server.commands.arguments.SkillArgument;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PlayerSkillCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicfight.skill.add.failed"));
    private static final SimpleCommandExceptionType ERROR_REMOVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicfight.skill.remove.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicfight.skill.clear.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        RequiredArgumentBuilder addCommandBuilder = Commands.argument((String)"targets", (ArgumentType)EntityArgument.players());
        RequiredArgumentBuilder removeCommandBuilder = Commands.argument((String)"targets", (ArgumentType)EntityArgument.players());
        for (SkillSlot skillSlot : SkillSlot.ENUM_MANAGER.universalValues()) {
            if (!skillSlot.category().learnable()) continue;
            addCommandBuilder.then(Commands.literal((String)skillSlot.toString().toLowerCase(Locale.ROOT)).then(Commands.argument((String)"skill", (ArgumentType)SkillArgument.skill()).executes(commandContext -> PlayerSkillCommand.addSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), skillSlot, (Holder<Skill>)((Holder)commandContext.getArgument("skill", Holder.class))))));
            removeCommandBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)skillSlot.toString().toLowerCase(Locale.ROOT)).executes(commandContext -> PlayerSkillCommand.removeSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), skillSlot, null))).then(Commands.argument((String)"skill", (ArgumentType)SkillArgument.skill()).executes(commandContext -> PlayerSkillCommand.removeSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets"), skillSlot, (Holder<Skill>)((Holder)commandContext.getArgument("skill", Holder.class))))));
        }
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"skill").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(commandContext -> PlayerSkillCommand.clearSkill((CommandSourceStack)commandContext.getSource(), (Collection<? extends ServerPlayer>)ImmutableList.of((Object)((CommandSourceStack)commandContext.getSource()).getPlayerOrException())))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(commandContext -> PlayerSkillCommand.clearSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.getPlayers((CommandContext)commandContext, (String)"targets")))))).then(Commands.literal((String)"add").then((ArgumentBuilder)addCommandBuilder))).then(Commands.literal((String)"remove").then((ArgumentBuilder)removeCommandBuilder));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"epicfight").then((ArgumentBuilder)builder));
    }

    public static int clearSkill(CommandSourceStack commandSourceStack, Collection<? extends ServerPlayer> targets) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class).ifPresent(playerpatch -> {
                playerpatch.getPlayerSkills().clearContainersAndLearnedSkills(true);
                SPClearSkills clearpacket = new SPClearSkills(player.getId());
                EpicFightNetworkManager.sendToPlayer(clearpacket, player, new CustomPacketPayload[0]);
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(clearpacket, (Entity)player, new CustomPacketPayload[0]);
            });
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.sendSuccess(PlayerSkillCommand.wrap(Component.translatable((String)"commands.epicfight.skill.clear.success.single", (Object[])new Object[]{targets.iterator().next().getDisplayName()})), true);
            } else {
                commandSourceStack.sendSuccess(PlayerSkillCommand.wrap(Component.translatable((String)"commands.epicfight.skill.clear.success.multiple", (Object[])new Object[]{i})), true);
            }
        } else {
            throw ERROR_CLEAR_FAILED.create();
        }
        return i;
    }

    public static int addSkill(CommandSourceStack commandSourceStack, Collection<? extends ServerPlayer> targets, SkillSlot slot, @NotNull Holder<Skill> skill) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class);
            SkillContainer skillContainer = playerpatch.getPlayerSkills().getSkillContainerFor(slot);
            if (!skillContainer.setSkill((Skill)skill.value())) continue;
            if (((Skill)skill.value()).getCategory().learnable()) {
                playerpatch.getPlayerSkills().addLearnedSkill((Skill)skill.value());
            }
            EpicFightNetworkManager.sendToPlayer(skillContainer.createSyncPacketToLocalPlayer(), serverPlayer, new CustomPacketPayload[0]);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(skillContainer.createSyncPacketToRemotePlayer(), (Entity)serverPlayer, new CustomPacketPayload[0]);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.sendSuccess(PlayerSkillCommand.wrap(Component.translatable((String)"commands.epicfight.skill.add.success.single", (Object[])new Object[]{skill.getRegisteredName(), targets.iterator().next().getDisplayName()})), true);
            } else {
                commandSourceStack.sendSuccess(PlayerSkillCommand.wrap(Component.translatable((String)"commands.epicfight.skill.add.success.multiple", (Object[])new Object[]{skill.getRegisteredName(), i})), true);
            }
        } else {
            throw ERROR_ADD_FAILED.create();
        }
        return i;
    }

    public static int removeSkill(CommandSourceStack commandSourceStack, Collection<? extends ServerPlayer> targets, SkillSlot slot, @Nullable Holder<Skill> skill) throws CommandSyntaxException {
        int i = 0;
        Holder<Skill> removedSkill = null;
        for (ServerPlayer serverPlayer : targets) {
            SkillContainer skillContainer;
            ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class);
            if (playerpatch == null) continue;
            if (skill == null) {
                skillContainer = playerpatch.getSkill(slot);
                if (skillContainer.getSkill() == null) continue;
                removedSkill = skillContainer.getSkill().holder();
                skillContainer.setSkill(null);
                EpicFightNetworkManager.sendToPlayer(new SPRemoveSkillAndLearn(removedSkill, slot), serverPlayer, new CustomPacketPayload[0]);
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(skillContainer.createSyncPacketToRemotePlayer(), (Entity)serverPlayer, new CustomPacketPayload[0]);
                ++i;
                continue;
            }
            skillContainer = playerpatch.getSkill(slot);
            if (!skillContainer.getSkill().equals(skill.value())) continue;
            playerpatch.getPlayerSkills().removeLearnedSkill((Skill)skill.value());
            removedSkill = skill;
            skillContainer.setSkill(null);
            EpicFightNetworkManager.sendToPlayer(new SPRemoveSkillAndLearn(skill, slot), serverPlayer, new CustomPacketPayload[0]);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(skillContainer.createSyncPacketToRemotePlayer(), (Entity)serverPlayer, new CustomPacketPayload[0]);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.sendSuccess(PlayerSkillCommand.wrap(Component.translatable((String)"commands.epicfight.skill.remove.success.single", (Object[])new Object[]{((Skill)removedSkill.value()).getTranslationKey(), targets.iterator().next().getDisplayName()})), true);
            } else {
                commandSourceStack.sendSuccess(PlayerSkillCommand.wrap(Component.translatable((String)"commands.epicfight.skill.remove.success.multiple", (Object[])new Object[]{skill.getRegisteredName(), i})), true);
            }
        } else {
            throw ERROR_REMOVE_FAILED.create();
        }
        return i;
    }

    private static <T> Supplier<T> wrap(T value) {
        return () -> value;
    }
}

