/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.GameRules;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PlayerStaminaCommand {
    private static final SimpleCommandExceptionType ERROR_MODIFYING_FAILED = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.epicfight.stamina.success.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"stamina").requires(commandSourceStack -> commandSourceStack.hasPermission(2));
        builder.then(Commands.literal((String)"get").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(command -> PlayerStaminaCommand.getStamina((CommandSourceStack)command.getSource(), EntityArgument.getPlayer((CommandContext)command, (String)"target")))));
        for (Operation operation : Operation.values()) {
            builder.then(((LiteralArgumentBuilder)Commands.literal((String)operation.name().toLowerCase(Locale.ROOT)).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command -> PlayerStaminaCommand.setStamina((CommandContext<CommandSourceStack>)command, Collections.singleton(((CommandSourceStack)command.getSource()).getPlayerOrException()), operation, DoubleArgumentType.getDouble((CommandContext)command, (String)"value"))))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(command -> PlayerStaminaCommand.setStamina((CommandContext<CommandSourceStack>)command, EntityArgument.getPlayers((CommandContext)command, (String)"target"), operation, DoubleArgumentType.getDouble((CommandContext)command, (String)"value"))))));
        }
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"epicfight").then((ArgumentBuilder)builder));
    }

    private static int getStamina(CommandSourceStack command, ServerPlayer serverplayer) {
        ServerPlayerPatch serverplayerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverplayer, ServerPlayerPatch.class);
        if (serverplayerpatch == null) {
            command.sendFailure((Component)Component.translatable((String)"commands.epicfight.stamina.failed.no_stamina"));
            return 0;
        }
        double stamina = serverplayerpatch.getStamina();
        command.sendSuccess(() -> Component.translatable((String)"commands.epicfight.stamina.value.get.success", (Object[])new Object[]{serverplayer.getName(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(stamina)}), false);
        return (int)stamina;
    }

    private static int setStamina(CommandContext<CommandSourceStack> command, Collection<ServerPlayer> players, Operation operation, double value) {
        int i = 0;
        double returnVal = 0.0;
        for (ServerPlayer serverplayer : players) {
            ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverplayer, ServerPlayerPatch.class);
            if (playerpatch == null) continue;
            double stamina = operation.func.apply(Double.valueOf(playerpatch.getStamina()), value);
            playerpatch.resetActionTick();
            playerpatch.setStamina((float)stamina);
            returnVal = playerpatch.getStamina();
            ++i;
        }
        if (i == 0) {
            ERROR_MODIFYING_FAILED.create();
        } else if (i == 1) {
            ((CommandSourceStack)command.getSource()).sendSuccess(PlayerStaminaCommand.wrap(Component.translatable((String)"commands.epicfight.stamina.success.self", (Object[])new Object[]{players.iterator().next().getDisplayName(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(returnVal)})), true);
        } else {
            for (ServerPlayer serverplayer : players) {
                if (!((CommandSourceStack)command.getSource()).getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) continue;
                serverplayer.sendSystemMessage((Component)Component.translatable((String)"commands.epicfight.stamina.success.other", (Object[])new Object[]{String.valueOf(i)}));
            }
            ((CommandSourceStack)command.getSource()).sendSuccess(PlayerStaminaCommand.wrap(Component.translatable((String)"commands.epicfight.stamina.success.other", (Object[])new Object[]{String.valueOf(i)})), true);
        }
        return i;
    }

    private static <T> Supplier<T> wrap(T value) {
        return () -> value;
    }

    private static enum Operation {
        ADD((value, operand) -> value + operand),
        SUBTRACT((value, operand) -> value - operand),
        SET((value, operand) -> operand);

        BiFunction<Double, Double, Double> func;

        private Operation(BiFunction<Double, Double, Double> func) {
            this.func = func;
        }
    }
}

