/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillSlot;

public class SkillArgument
implements ArgumentType<Holder<Skill>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("epicfight:dodge");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_SKILL = new DynamicCommandExceptionType(obj -> Component.translatable((String)"epicfight.skillNotFound", (Object[])new Object[]{obj}));
    private static final DynamicCommandExceptionType ERROR_INAPPROPRICATE_SKILL = new DynamicCommandExceptionType(obj -> Component.translatable((String)"epicfight.invalid_skill", (Object[])new Object[]{obj}));

    public static SkillArgument skill() {
        return new SkillArgument();
    }

    public Holder<Skill> parse(StringReader p_98428_) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocation.read((StringReader)p_98428_);
        Optional skill = EpicFightRegistries.SKILL.getHolder(resourcelocation);
        if (skill.isEmpty()) {
            throw ERROR_UNKNOWN_SKILL.create((Object)resourcelocation);
        }
        if (!((Skill)((Holder.Reference)skill.get()).value()).getCategory().learnable()) {
            throw ERROR_INAPPROPRICATE_SKILL.create((Object)resourcelocation);
        }
        return (Holder)skill.get();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        SkillCategory skillCategory;
        CommandNode commandNode;
        if (commandContext.getNodes().size() > 5 && (commandNode = ((ParsedCommandNode)commandContext.getNodes().get(4)).getNode()) instanceof LiteralCommandNode) {
            LiteralCommandNode literalNode = (LiteralCommandNode)commandNode;
            skillCategory = SkillArgument.nullParam(SkillSlot.ENUM_MANAGER.getOrThrow(literalNode.getLiteral()));
        } else {
            skillCategory = null;
        }
        SkillCategory skillCategory2 = skillCategory;
        return SharedSuggestionProvider.suggestResource(EpicFightRegistries.SKILL.stream().filter(skill -> skill.getCategory().learnable() && skill.getCategory().equals(skillCategory2)).map(arg_0 -> EpicFightRegistries.SKILL.getKey(arg_0)), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static SkillCategory nullParam(SkillSlot slot) {
        return slot == null ? null : slot.category();
    }
}

