/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.dodge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.client.input.InputManager;
import yesman.epicfight.api.client.input.MovementDirection;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.input.InputUtils;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class KnockdownWakeupSkill
extends DodgeSkill {
    public KnockdownWakeupSkill(DodgeSkill.Builder<?> builder) {
        super(builder);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void gatherArguments(SkillContainer container, ControlEngine controlEngine, CompoundTag arguments) {
        LocalPlayerPatch executor = container.getClientExecutor();
        LocalPlayer localPlayer = (LocalPlayer)executor.getOriginal();
        float pulse = (float)((LocalPlayer)executor.getOriginal()).getAttributeValue(Attributes.SNEAKING_SPEED);
        InputUtils.sneakingTick(localPlayer, false, pulse);
        MovementDirection movementDirection = MovementDirection.fromInputState(InputManager.getInputState(localPlayer.input));
        int horizon = movementDirection.horizontal();
        float yRot = Minecraft.getInstance().gameRenderer.getMainCamera().getYRot();
        arguments.putInt("direction", horizon >= 0 ? 0 : 1);
        arguments.putFloat("yRot", yRot);
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executor) {
        EntityState playerState = executor.getEntityState();
        float elapsedTime = ((Animator)executor.getAnimator()).getPlayerFor(null).getElapsedTime();
        return !executor.isInAir() && (!playerState.hurt() || playerState.knockDown()) && !((Player)executor.getOriginal()).isInWater() && !((Player)executor.getOriginal()).onClimbable() && elapsedTime > 0.7f;
    }
}

