/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.identity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.neoevent.playerpatch.DodgeSuccessEvent;
import yesman.epicfight.api.neoevent.playerpatch.SetTargetEvent;
import yesman.epicfight.api.neoevent.playerpatch.SkillCastEvent;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.neoevent.playerpatch.TargetIndicatorCheckEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class RevelationSkill
extends Skill {
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> motions;
    protected final Map<EntityType<?>, Integer> maxRevelationStacks = Maps.newHashMap();
    protected int blockStack;
    protected int parryStack;
    protected int dodgeStack;
    protected int defaultRevelationStacks;

    public static Builder createRevelationSkillBuilder() {
        return (Builder)((Builder)((Builder)new Builder((Function<Builder, ? extends Skill>)((Function<Builder, Skill>)RevelationSkill::new)).addMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.REVELATION_TWOHAND).addMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.REVELATION_TWOHAND).addMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.REVELATION_TWOHAND).setCategory(SkillCategories.IDENTITY)).setActivateType(Skill.ActivateType.DURATION)).setResource(Skill.Resource.NONE);
    }

    public RevelationSkill(Builder builder) {
        super(builder);
        this.motions = builder.motions;
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.maxRevelationStacks.clear();
        this.blockStack = parameters.getInt("block_stacks");
        this.parryStack = parameters.getInt("parry_stacks");
        this.dodgeStack = parameters.getInt("dodge_stacks");
        this.defaultRevelationStacks = parameters.getInt("default_revelation_stacks");
        CompoundTag maxStacks = parameters.getCompound("max_revelations");
        for (String registryName : maxStacks.getAllKeys()) {
            EntityType entityType = EntityType.byString((String)registryName).orElse(null);
            if (entityType != null) {
                this.maxRevelationStacks.put(entityType, maxStacks.getInt(registryName));
                continue;
            }
            EpicFightMod.LOGGER.warn("Revelation registry error: no entity type named : " + registryName);
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.CLIENT)
    public void skillExecuteEvent(SkillCastEvent event, SkillContainer skillContainer) {
        if (skillContainer.getExecutor().isLogicalClient()) {
            Skill skill = event.getSkillContainer().getSkill();
            if (skill.getCategory() != SkillCategories.WEAPON_INNATE) {
                return;
            }
            if (skillContainer.getExecutor().getTarget() != null) {
                EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)skillContainer.getExecutor().getTarget(), LivingEntityPatch.class).ifPresent(entitypatch -> {
                    if (this.isActivated(skillContainer) && skillContainer.sendCastRequest(skillContainer.getClientExecutor(), ControlEngine.getInstance()).isExecutable()) {
                        skillContainer.setDuration(0);
                        event.setCanceled(true);
                    }
                });
            }
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void setTargetEvent(SetTargetEvent event, SkillContainer skillContainer) {
        skillContainer.getDataManager().setDataSync(EpicFightSkillDataKeys.STACKS, 0);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER, priority=-1)
    public void dodgeSuccessEvent(DodgeSuccessEvent event, SkillContainer skillContainer) {
        LivingEntity target = skillContainer.getExecutor().getTarget();
        if (target != null && target.is(event.getDamageSource().getDirectEntity())) {
            this.checkStackAndActivate(skillContainer, (ServerPlayerPatch)event.getPlayerPatch(), target, skillContainer.getDataManager().getDataValue(EpicFightSkillDataKeys.STACKS), this.dodgeStack);
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER, priority=-1)
    public void hurtEventPre(TakeDamageEvent.Income event, SkillContainer skillContainer) {
        LivingEntity target;
        if (event.getResult() == AttackResult.ResultType.BLOCKED && (target = skillContainer.getExecutor().getTarget()) != null && target.is(event.getDamageSource().getDirectEntity())) {
            int stacks = event.isParried() ? this.parryStack : this.blockStack;
            this.checkStackAndActivate(skillContainer, (ServerPlayerPatch)event.getPlayerPatch(), target, skillContainer.getDataManager().getDataValue(EpicFightSkillDataKeys.STACKS), stacks);
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.CLIENT, priority=-1)
    public void targetIndicatorEvent(TargetIndicatorCheckEvent event, SkillContainer skillContainer) {
        if (this.isActivated(skillContainer)) {
            event.setType(TargetIndicatorCheckEvent.Type.FLASH);
        }
    }

    @Override
    public void executeOnServer(SkillContainer container, CompoundTag arguments) {
        super.executeOnServer(container, arguments);
        CapabilityItem holdingItem = container.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND);
        AnimationManager.AnimationAccessor<AttackAnimation> animation = this.motions.containsKey(holdingItem.getWeaponCategory()) ? this.motions.get(holdingItem.getWeaponCategory()).apply(holdingItem, container.getExecutor()) : Animations.REVELATION_ONEHAND;
        container.getExecutor().playAnimationSynchronized(animation, 0.0f);
    }

    public void checkStackAndActivate(SkillContainer container, ServerPlayerPatch playerpatch, LivingEntity target, int stacks, int addStacks) {
        int plusStack = stacks + addStacks;
        int maxStackSize = this.maxRevelationStacks.getOrDefault(target.getType(), this.defaultRevelationStacks);
        if (plusStack < maxStackSize) {
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.STACKS, plusStack);
        } else {
            if (!this.isActivated(container)) {
                this.setDurationSynchronize(container, this.maxDuration);
            }
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.STACKS, 0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return container.getExecutor().getTarget() != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        guiGraphics.blit(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        int stacks = container.getRemainDuration() > 0 ? 0 : this.maxRevelationStacks.getOrDefault(container.getExecutor().getTarget().getType(), this.defaultRevelationStacks) - container.getDataManager().getDataValue(EpicFightSkillDataKeys.STACKS);
        guiGraphics.drawString(gui.getFont(), String.format("%d", stacks), x + 18.0f, y + 14.0f, 0xFFFFFF, true);
    }

    public static class Builder
    extends SkillBuilder<Builder> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> motions = Maps.newHashMap();

        public Builder(Function<Builder, ? extends Skill> constructor) {
            super(constructor);
        }

        public Builder addMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>> function) {
            this.motions.put(weaponCategory, function);
            return this;
        }
    }
}

