/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector4f;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.EntityDecorations;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;

public class AdaptiveSkinSkill
extends PassiveSkill {
    private final Map<TagKey<DamageType>, Vec3f> protectableDamageTypeTags;
    private float damageResistance;
    private int maxResistanceStack;

    public static Builder createAdaptiveSkinBuilder() {
        return (Builder)((Builder)new Builder((Function<Builder, ? extends Skill>)((Function<Builder, Skill>)AdaptiveSkinSkill::new)).addProtectableDamageTypeTags((Map<TagKey<DamageType>, Vec3f>)ImmutableMap.of(EpicFightDamageTypeTags.IS_MELEE, (Object)new Vec3f(0.8901961f, 0.49803922f, 0.49803922f), (Object)DamageTypeTags.IS_PROJECTILE, (Object)new Vec3f(0.4f, 0.77254903f, 1.0f), (Object)DamageTypeTags.IS_FIRE, (Object)new Vec3f(0.8980392f, 0.56078434f, 0.25882354f), EpicFightDamageTypeTags.IS_MAGIC, (Object)new Vec3f(0.8862745f, 0.6039216f, 0.91764706f), (Object)DamageTypeTags.IS_EXPLOSION, (Object)new Vec3f(0.8117647f, 0.8039216f, 0.47058824f))).setCategory(SkillCategories.PASSIVE)).setResource(Skill.Resource.NONE);
    }

    public AdaptiveSkinSkill(Builder builder) {
        super(builder);
        this.protectableDamageTypeTags = Collections.unmodifiableMap(builder.protectableDamageTypeTags);
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.damageResistance = parameters.getFloat("damage_resistance");
        this.maxResistanceStack = parameters.getInt("max_resistance_stack");
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void takeDamagePost(TakeDamageEvent.Pre event, SkillContainer container) {
        TagKey<DamageType> currentResisting = container.getDataManager().getDataValue(EpicFightSkillDataKeys.RESISTING_DAMAGE_TYPE);
        int stacks = container.getDataManager().getDataValueOptional(EpicFightSkillDataKeys.STACKS).orElse(0);
        if (event.getDamageSource().is(currentResisting)) {
            event.attachValueModifier(ValueModifier.multiplier(1.0f - this.damageResistance * (float)stacks));
            if (stacks < this.maxResistanceStack) {
                container.getExecutor().playSound((Holder<SoundEvent>)EpicFightSounds.ADAPTIVE_SKIN_INCREASE, 1.0f, 0.0f, 0.0f);
                container.getDataManager().setDataSyncF(EpicFightSkillDataKeys.STACKS, v -> v + 1);
            }
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.TICK_RECORD, ((Player)container.getExecutor().getOriginal()).tickCount);
        } else if (stacks <= 1) {
            for (TagKey<DamageType> protectableTag : this.protectableDamageTypeTags.keySet()) {
                if (!event.getDamageSource().is(protectableTag)) continue;
                container.getDataManager().setDataSync(EpicFightSkillDataKeys.STACKS, 1);
                container.getDataManager().setDataSync(EpicFightSkillDataKeys.RESISTING_DAMAGE_TYPE, protectableTag);
                container.getDataManager().setDataSync(EpicFightSkillDataKeys.TICK_RECORD, ((Player)container.getExecutor().getOriginal()).tickCount);
                if (stacks == 0) {
                    container.getExecutor().playSound((Holder<SoundEvent>)EpicFightSounds.ADAPTIVE_SKIN_INCREASE, 1.0f, 0.0f, 0.0f);
                } else {
                    container.getExecutor().playSound((Holder<SoundEvent>)EpicFightSounds.ADAPTIVE_SKIN_DECREASE, 1.0f, 0.0f, 0.0f);
                }
                break;
            }
        } else {
            boolean adaptableType = false;
            for (TagKey<DamageType> protectableTag : this.protectableDamageTypeTags.keySet()) {
                if (!event.getDamageSource().is(protectableTag)) continue;
                adaptableType = true;
                break;
            }
            if (adaptableType) {
                container.getExecutor().playSound((SoundEvent)EpicFightSounds.ADAPTIVE_SKIN_DECREASE.get(), 1.0f, 0.0f, 0.0f);
                container.getDataManager().setDataSyncF(EpicFightSkillDataKeys.STACKS, v -> v - 1);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInitiateClient(final SkillContainer container) {
        container.getExecutor().getEntityDecorations().addDecorationOverlay(EntityDecorations.ADAPTIVE_SKIN_OVERLAY, new EntityDecorations.DecorationOverlay(){

            @Override
            public RenderType getRenderType() {
                TagKey<DamageType> resistingDamageTypeTagKey = container.getExecutor().getSkill(AdaptiveSkinSkill.this).getDataManager().getDataValue(EpicFightSkillDataKeys.RESISTING_DAMAGE_TYPE);
                Vec3f color = AdaptiveSkinSkill.this.getGlintColor(resistingDamageTypeTagKey);
                return EpicFightRenderTypes.coloredGlintWorldRendertype(container.getExecutor().getOriginal(), color.x, color.y, color.z);
            }

            @Override
            public boolean shouldRender() {
                return container.getExecutor().getSkill(AdaptiveSkinSkill.this).getDataManager().getDataValueOptional(EpicFightSkillDataKeys.RESISTING_DAMAGE_TYPE).orElse(EpicFightDamageTypeTags.NONE) != EpicFightDamageTypeTags.NONE;
            }

            @Override
            public boolean shouldRemove() {
                return container.getExecutor().getSkill(AdaptiveSkinSkill.this) == null;
            }
        });
        container.getExecutor().getEntityDecorations().addColorModifier(EntityDecorations.ADAPTIVE_SKIN_COLOR, new EntityDecorations.RenderAttributeModifier<Vector4f>(){

            @Override
            public void modifyValue(Vector4f val, float partialTick) {
                TagKey<DamageType> resistingDamageTypeTagKey = container.getExecutor().getSkill(AdaptiveSkinSkill.this).getDataManager().getDataValue(EpicFightSkillDataKeys.RESISTING_DAMAGE_TYPE);
                if (!EpicFightDamageTypeTags.NONE.equals(resistingDamageTypeTagKey)) {
                    Vec3f color = AdaptiveSkinSkill.this.getGlintColor(resistingDamageTypeTagKey);
                    val.x = color.x;
                    val.y = color.y;
                    val.z = color.z;
                }
            }

            @Override
            public boolean shouldRemove() {
                return container.getExecutor().getSkill(AdaptiveSkinSkill.this) == null;
            }
        });
    }

    @Override
    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        TagKey<DamageType> resistingDamageTypeTag = container.getDataManager().getDataValue(EpicFightSkillDataKeys.RESISTING_DAMAGE_TYPE);
        if (!EpicFightDamageTypeTags.NONE.equals(resistingDamageTypeTag) && ((Player)container.getExecutor().getOriginal()).tickCount - container.getDataManager().getDataValueOptional(EpicFightSkillDataKeys.TICK_RECORD).orElse(0) > 300) {
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.RESISTING_DAMAGE_TYPE, EpicFightDamageTypeTags.NONE);
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.STACKS, 0);
        }
    }

    private Vec3f getGlintColor(TagKey<DamageType> tagKey) {
        return this.protectableDamageTypeTags.get(tagKey);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        TagKey<DamageType> resistingDamageTypeTag = container.getDataManager().getDataValue(EpicFightSkillDataKeys.RESISTING_DAMAGE_TYPE);
        return !EpicFightDamageTypeTags.NONE.equals(resistingDamageTypeTag) && this.protectableDamageTypeTags.containsKey(resistingDamageTypeTag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        int lastHitTick;
        Vec3f color = this.protectableDamageTypeTags.get(container.getDataManager().getDataValue(EpicFightSkillDataKeys.RESISTING_DAMAGE_TYPE));
        guiGraphics.innerBlit(this.getSkillTexture(), (int)x, (int)x + 24, (int)y, (int)y + 24, 0, 0.0f, 1.0f, 0.0f, 1.0f, color.x, color.y, color.z, 1.0f);
        int stacks = container.getDataManager().getDataValue(EpicFightSkillDataKeys.STACKS);
        if (stacks > 1) {
            guiGraphics.drawString(gui.getFont(), String.valueOf(stacks), x + 18.0f, y + 16.0f, 0xFFFFFF, true);
        }
        if (((Player)container.getExecutor().getOriginal()).tickCount - (lastHitTick = container.getDataManager().getDataValueOptional(EpicFightSkillDataKeys.TICK_RECORD).orElse(0).intValue()) > 200) {
            int remainseconds = 1 + (100 - (((Player)container.getExecutor().getOriginal()).tickCount - lastHitTick - 200)) / 20;
            guiGraphics.drawString(gui.getFont(), String.valueOf(remainseconds), x + 8.0f, y + 8.0f, 0xFFFFFF, true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.damageResistance * 100.0f));
        list.add(this.maxResistanceStack);
        StringBuilder sb = new StringBuilder();
        for (TagKey<DamageType> tag : this.protectableDamageTypeTags.keySet()) {
            String tagKey = String.format("tag.%s.%s.%s", tag.registry().location().getPath(), tag.location().getNamespace(), tag.location().getPath());
            sb.append("- " + Component.translatable((String)tagKey).getString() + "\n");
        }
        list.add(sb.toString());
        return list;
    }

    public static class Builder
    extends SkillBuilder<Builder> {
        protected final Map<TagKey<DamageType>, Vec3f> protectableDamageTypeTags = new LinkedHashMap<TagKey<DamageType>, Vec3f>();

        public Builder(Function<Builder, ? extends Skill> constructor) {
            super(constructor);
        }

        public Builder addProtectableDamageTypeTags(Map<TagKey<DamageType>, Vec3f> tags) {
            this.protectableDamageTypeTags.putAll(tags);
            return this;
        }
    }
}

