/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.neoevent.playerpatch.SkillConsumeEvent;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.passive.PassiveSkill;

public class ForbiddenStrengthSkill
extends PassiveSkill {
    public ForbiddenStrengthSkill(SkillBuilder<?> builder) {
        super((SkillBuilder<? extends SkillBuilder>)builder);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.BOTH)
    public void skillConsumeEvent(SkillConsumeEvent event, SkillContainer container) {
        if (event.getResourceType() == Skill.Resource.STAMINA && event.getSkill() != this && !container.getExecutor().hasStamina(event.getAmount()) && !((Player)container.getExecutor().getOriginal()).isCreative()) {
            event.setResourceType(Skill.Resource.HEALTH);
            float healthConsumeAmount = event.getAmount() - container.getExecutor().getStamina();
            event.setAmount(healthConsumeAmount);
            if (!container.getExecutor().isLogicalClient() && event.getResourceType().predicate.canExecute(container, container.getExecutor(), healthConsumeAmount)) {
                container.getExecutor().setStamina(0.0f);
                Player player = (Player)container.getExecutor().getOriginal();
                ServerLevel serverLevel = (ServerLevel)player.level();
                serverLevel.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)EpicFightSounds.FORBIDDEN_STRENGTH.get(), player.getSoundSource(), 1.0f, 1.0f);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, player.getX(), player.getY(0.5), player.getZ(), (int)healthConsumeAmount, 0.1, 0.0, 0.1, 0.2);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL, player.getX(), player.getY(0.5), player.getZ(), (int)healthConsumeAmount * 3, 0.0, 0.0, 0.75, 0.1);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.translatable((String)"attribute.name.epicfight.health.consume.tooltip"), (Component)Component.translatable((String)"skill.epicfight.forbidden_strength.consume.tooltip"), SkillBookScreen.HEALTH_TEXTURE_INFO);
        return true;
    }
}

