/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.neoevent.playerpatch.SkillCancelEvent;
import yesman.epicfight.api.neoevent.playerpatch.SkillConsumeEvent;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.network.server.SPSkillFeedback;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class HyperVitalitySkill
extends PassiveSkill {
    public HyperVitalitySkill(SkillBuilder<?> builder) {
        super((SkillBuilder<? extends SkillBuilder>)builder);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.BOTH, priority=1)
    public void skillConsumeEvent(SkillConsumeEvent event, SkillContainer container) {
        if (!this.isDisabled(container) && event.getSkill().getCategory() == SkillCategories.WEAPON_INNATE) {
            float consumption;
            Object playerpatch = event.getPlayerPatch();
            Player player = (Player)((EntityPatch)playerpatch).getOriginal();
            if (((PlayerPatch)playerpatch).getSkill(SkillSlots.WEAPON_INNATE).getStack() < 1 && container.getStack() > 0 && !player.isCreative() && ((PlayerPatch)playerpatch).consumeForSkill((Skill)this, Skill.Resource.STAMINA, (consumption = event.getSkill().getConsumption()) * 0.1f)) {
                event.setResourceType(Skill.Resource.NONE);
                container.setMaxResource(consumption * 0.2f);
                container.runOnServer(serverplayerpatch -> {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)EpicFightSounds.HYPERVITALITY.get(), player.getSoundSource(), 1.0f, 1.0f);
                    container.setMaxDuration(event.getSkill().getMaxDuration());
                    container.activate();
                    EpicFightNetworkManager.sendToPlayer(SPSkillFeedback.executed(container.getSlot()), (ServerPlayer)serverplayerpatch.getOriginal(), new CustomPacketPayload[0]);
                    SPEntityPairingPacket pairingPacket = new SPEntityPairingPacket(player.getId(), EntityPairingPacketTypes.FLASH_WHITE);
                    pairingPacket.buffer().writeInt(4);
                    pairingPacket.buffer().writeInt(15);
                    pairingPacket.buffer().writeInt(8);
                    pairingPacket.buffer().writeBoolean(false);
                    EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(pairingPacket, (ServerPlayer)serverplayerpatch.getOriginal(), new CustomPacketPayload[0]);
                });
            }
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void skillCancelEvent(SkillCancelEvent event, SkillContainer container) {
        container.runOnServer(serverplayerpatch -> {
            if (!((Player)container.getExecutor().getOriginal()).isCreative() && event.getSkillContainer().getSkill().getCategory() == SkillCategories.WEAPON_INNATE && this.isActivated(container)) {
                container.setResource(0.0f);
                container.deactivate();
                this.setStackSynchronize(container, container.getStack() - 1);
                EpicFightNetworkManager.sendToPlayer(SPSkillFeedback.executed(container.getSlot()), (ServerPlayer)serverplayerpatch.getOriginal(), new CustomPacketPayload[0]);
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(SkillContainer container, CompoundTag arguments) {
        super.executeOnClient(container, arguments);
        container.activate();
    }

    @Override
    public void cancelOnClient(SkillContainer container, CompoundTag arguments) {
        super.cancelOnClient(container, arguments);
        container.deactivate();
    }

    @Override
    public boolean shouldDraw(SkillContainer container) {
        return this.isActivated(container) || container.getStack() == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        guiGraphics.blit(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        if (!this.isActivated(container)) {
            String remainTime = String.format("%.0f", Float.valueOf(container.getMaxResource() - container.getResource()));
            guiGraphics.drawString(gui.getFont(), remainTime, x + 12.0f - (float)(4 * remainTime.length()), y + 6.0f, 0xFFFFFF, true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.translatable((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.translatable((String)"skill.epicfight.hypervitality.consume.tooltip"), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }
}

