/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.neoevent.playerpatch.DealDamageEvent;
import yesman.epicfight.api.neoevent.playerpatch.PlayerKilledEvent;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.network.server.SPPlayUISound;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class VengeanceSkill
extends PassiveSkill {
    private float damageBonus;

    public VengeanceSkill(SkillBuilder<?> builder) {
        super((SkillBuilder<? extends SkillBuilder>)builder);
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.damageBonus = parameters.getFloat("damage_bonus");
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void takeDamagePre(TakeDamageEvent.Income event, SkillContainer container) {
        Entity entity;
        if (event.getDamageSource().getEntity() == null) {
            return;
        }
        int currentTargetId = container.getDataManager().getDataValue(EpicFightSkillDataKeys.ENTITY_ID);
        if (currentTargetId == -1 && (entity = event.getDamageSource().getEntity()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            VengeanceSkill.setNewTarget(container, livingentity);
        } else if (currentTargetId == event.getDamageSource().getEntity().getId()) {
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.TICK_RECORD, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).tickCount);
        } else if (currentTargetId != event.getDamageSource().getEntity().getId() && (entity = event.getDamageSource().getEntity()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            if (VengeanceSkill.canResetTarget(container)) {
                VengeanceSkill.setNewTarget(container, livingentity);
            }
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void dealDamagePre(DealDamageEvent.Pre event, SkillContainer container) {
        int currentTargetId = container.getDataManager().getDataValue(EpicFightSkillDataKeys.ENTITY_ID);
        if (currentTargetId == event.getTarget().getId()) {
            event.getDamageSource().attachDamageModifier(ValueModifier.multiplier(1.0f + this.damageBonus));
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.TICK_RECORD, ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).tickCount);
        } else if (container.isActivated()) {
            float f = this.damageBonus * container.getDurationRatio(1.0f);
            event.getDamageSource().attachDamageModifier(ValueModifier.multiplier(1.0f + f));
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void playerKilled(PlayerKilledEvent event, SkillContainer container) {
        if (container.isActivated()) {
            return;
        }
        int currentTargetId = container.getDataManager().getDataValue(EpicFightSkillDataKeys.ENTITY_ID);
        if (currentTargetId == event.getKilledEntity().getId()) {
            this.executeOnServer(container, null);
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.ENTITY_ID, -1);
        }
    }

    @Override
    public void onRemoved(SkillContainer container) {
        container.runOnServer(serverplayerpatch -> {
            int currentTargetId = container.getDataManager().getDataValue(EpicFightSkillDataKeys.ENTITY_ID);
            Entity entity = container.getExecutor().getLevel().getEntity(currentTargetId);
            if (entity != null) {
                EpicFightNetworkManager.sendToPlayer(new SPEntityPairingPacket(currentTargetId, EntityPairingPacketTypes.VENGEANCE_TARGET_CANCEL), (ServerPlayer)serverplayerpatch.getOriginal(), new CustomPacketPayload[0]);
            }
        });
        super.onRemoved(container);
    }

    @Override
    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        container.runOnServer(serverplayerpatch -> {
            int currentTargetId = container.getDataManager().getDataValue(EpicFightSkillDataKeys.ENTITY_ID);
            if (currentTargetId > -1) {
                Entity entity = container.getExecutor().getLevel().getEntity(currentTargetId);
                if (((Player)container.getExecutor().getOriginal()).tickCount - container.getDataManager().getDataValue(EpicFightSkillDataKeys.TICK_RECORD) >= 160) {
                    VengeanceSkill.cancelTarget(container);
                } else if (entity == null || !entity.isAlive()) {
                    VengeanceSkill.cancelTarget(container);
                }
            }
        });
    }

    @Override
    public void executeOnServer(SkillContainer container, CompoundTag args) {
        super.executeOnServer(container, args);
        ((Player)container.getExecutor().getOriginal()).playSound((SoundEvent)EpicFightSounds.VENGEANCE.get(), 1.0f, 1.0f);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPEntityPairingPacket(((Player)container.getExecutor().getOriginal()).getId(), EntityPairingPacketTypes.VENGEANCE_OVERLAY), (ServerPlayer)container.getServerExecutor().getOriginal(), new CustomPacketPayload[0]);
    }

    @Override
    public void cancelOnServer(SkillContainer container, CompoundTag args) {
        super.cancelOnServer(container, args);
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPEntityPairingPacket(((Player)container.getExecutor().getOriginal()).getId(), EntityPairingPacketTypes.VENGEANCE_TARGET_CANCEL), (ServerPlayer)container.getServerExecutor().getOriginal(), new CustomPacketPayload[0]);
    }

    @Override
    public void onTracked(SkillContainer container, EpicFightNetworkManager.PayloadBundleBuilder payloadBuilder) {
        if (container.isActivated()) {
            payloadBuilder.and(new SPEntityPairingPacket(((Player)container.getExecutor().getOriginal()).getId(), EntityPairingPacketTypes.VENGEANCE_OVERLAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(SkillContainer container, FriendlyByteBuf args) {
        container.activate();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)EpicFightSounds.VENGEANCE.get()), (float)1.0f, (float)1.0f));
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)EpicFightSounds.VENGEANCE.get()), (float)1.0f, (float)1.0f));
    }

    public static boolean tickExceeded(SkillContainer container) {
        return ((Player)container.getExecutor().getOriginal()).tickCount - container.getDataManager().getDataValue(EpicFightSkillDataKeys.TICK_RECORD) >= 160;
    }

    public static boolean canResetTarget(SkillContainer container) {
        return ((Player)container.getExecutor().getOriginal()).tickCount - container.getDataManager().getDataValue(EpicFightSkillDataKeys.TICK_RECORD) >= 80;
    }

    public static void setNewTarget(SkillContainer container, LivingEntity target) {
        VengeanceSkill.cancelTarget(container);
        container.getDataManager().setDataSync(EpicFightSkillDataKeys.ENTITY_ID, target.getId());
        container.getDataManager().setDataSync(EpicFightSkillDataKeys.TICK_RECORD, ((Player)container.getExecutor().getOriginal()).tickCount);
        container.runOnServer(serverplayerpatch -> {
            EpicFightNetworkManager.sendToPlayer(new SPPlayUISound((Holder<SoundEvent>)EpicFightSounds.VENGEANCE), (ServerPlayer)serverplayerpatch.getOriginal(), new CustomPacketPayload[0]);
            EpicFightNetworkManager.sendToPlayer(new SPEntityPairingPacket(target.getId(), EntityPairingPacketTypes.VENGEANCE_OVERLAY), (ServerPlayer)serverplayerpatch.getOriginal(), new CustomPacketPayload[0]);
        });
    }

    public static void cancelTarget(SkillContainer container) {
        int currentTargetId = container.getDataManager().getDataValue(EpicFightSkillDataKeys.ENTITY_ID);
        Entity entity = container.getExecutor().getLevel().getEntity(currentTargetId);
        container.getDataManager().setDataSync(EpicFightSkillDataKeys.ENTITY_ID, -1);
        container.runOnServer(serverplayerpatch -> {
            if (entity != null) {
                EpicFightNetworkManager.sendToPlayer(new SPEntityPairingPacket(currentTargetId, EntityPairingPacketTypes.VENGEANCE_TARGET_CANCEL), (ServerPlayer)serverplayerpatch.getOriginal(), new CustomPacketPayload[0]);
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return container.isActivated() || container.getDataManager().getDataValue(EpicFightSkillDataKeys.ENTITY_ID) > -1 && !VengeanceSkill.tickExceeded(container);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        guiGraphics.blit(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        if (container.isActivated()) {
            float f = Math.round(this.damageBonus * 100.0f * container.getDurationRatio(1.0f));
            guiGraphics.drawString(gui.getFont(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(f) + "%", x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        } else if (VengeanceSkill.canResetTarget(container)) {
            int seconds = 4 - (((Player)container.getExecutor().getOriginal()).tickCount - container.getDataManager().getDataValue(EpicFightSkillDataKeys.TICK_RECORD) - 80) / 20;
            guiGraphics.drawString(gui.getFont(), String.valueOf(seconds), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.damageBonus * 100.0f));
        list.add(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.damageBonus * 100.0f));
        list.add(String.valueOf(this.maxDuration / 20));
        return list;
    }
}

