/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.neoevent.playerpatch.AttackEndEvent;
import yesman.epicfight.api.neoevent.playerpatch.DealDamageEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class GraspingSpireSkill
extends WeaponInnateSkill {
    private AnimationManager.AnimationAccessor<? extends AttackAnimation> first = Animations.GRASPING_SPIRAL_FIRST;
    private AnimationManager.AnimationAccessor<? extends AttackAnimation> second = Animations.GRASPING_SPIRAL_SECOND;

    public GraspingSpireSkill(WeaponInnateSkill.Builder<?> builder) {
        super(builder);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void attackAnimationEndEvent(AttackEndEvent event, SkillContainer skillContainer) {
        if (this.first.equals(event.getAnimation())) {
            skillContainer.getDataManager().setDataSync(EpicFightSkillDataKeys.LAST_HIT_COUNT, ((ServerPlayerPatch)event.getPlayerPatch()).getCurrentlyActuallyHitEntities().size());
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void dealDamagePost(DealDamageEvent.Post event, SkillContainer skillContainer) {
        if (this.second.equals(event.getDamageSource().getAnimation())) {
            event.getDamageSource().attachImpactModifier(ValueModifier.adder((float)skillContainer.getDataManager().getDataValue(EpicFightSkillDataKeys.LAST_HIT_COUNT).intValue() * 0.4f));
        }
    }

    @Override
    public void executeOnServer(SkillContainer container, CompoundTag arguments) {
        container.getExecutor().playAnimationSynchronized(this.first, 0.0f);
        super.executeOnServer(container, arguments);
    }

    @Override
    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List<Component> list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Pierce:");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Second Strike:");
        return list;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        ((AttackAnimation)this.first.get()).phases[0].addProperties(((Map)this.properties.get(0)).entrySet());
        ((AttackAnimation)this.second.get()).phases[0].addProperties(((Map)this.properties.get(1)).entrySet());
        return this;
    }
}

