/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.weaponinnate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.neoevent.MappedMovementInputUpdateEvent;
import yesman.epicfight.api.neoevent.playerpatch.DealDamageEvent;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class LiechtenauerSkill
extends WeaponInnateSkill {
    private int returnDuration;

    public LiechtenauerSkill(WeaponInnateSkill.Builder<?> builder) {
        super(builder);
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.returnDuration = parameters.getInt("return_duration");
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void dealDamagePost(DealDamageEvent.Post event, SkillContainer skillContainer) {
        if (this.isActivated(skillContainer) && !this.isDisabled(skillContainer) && event.getAttackDamage() > event.getTarget().getHealth()) {
            this.setDurationSynchronize(skillContainer, Math.min(this.maxDuration, skillContainer.getRemainDuration() + this.returnDuration));
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER, priority=0)
    public void takeDamagePre(TakeDamageEvent.Income event, SkillContainer container) {
        int phaseLevel = ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().getLevel();
        if (event.getDamage() > 0.0f && this.isActivated(container) && !this.isDisabled(container) && phaseLevel > 0 && phaseLevel < 3 && this.canExecute(container) && LiechtenauerSkill.isBlockableSource(event.getDamageSource())) {
            DamageSource damageSource = event.getDamageSource();
            boolean isFront = false;
            Vec3 sourceLocation = damageSource.getSourcePosition();
            if (sourceLocation != null) {
                Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getViewVector(1.0f);
                Vec3 toSourceLocation = sourceLocation.subtract(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).position()).normalize();
                if (toSourceLocation.dot(viewVector) > 0.0) {
                    isFront = true;
                }
            }
            if (isFront) {
                Entity entity;
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                ((HitParticleType)((Object)EpicFightParticles.HIT_BLUNT.get())).spawnParticleWithArgument(playerentity.serverLevel(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.getDirectEntity());
                float knockback = 0.25f;
                if (damageSource instanceof EpicFightDamageSource) {
                    EpicFightDamageSource epicfightSource = (EpicFightDamageSource)damageSource;
                    knockback += Math.min(epicfightSource.calculateImpact() * 0.1f, 1.0f);
                }
                if ((entity = damageSource.getDirectEntity()) instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    float modifiedKnockback = EnchantmentHelper.modifyKnockback((ServerLevel)((ServerLevel)livingentity.level()), (ItemStack)livingentity.getItemInHand(livingentity.getUsedItemHand()), (Entity)livingentity, (DamageSource)damageSource, (float)knockback);
                    knockback = (modifiedKnockback - knockback) * 0.1f;
                }
                EpicFightCapabilities.getUnparameterizedEntityPatch(event.getDamageSource().getEntity(), LivingEntityPatch.class).ifPresent(attackerpatch -> attackerpatch.setLastAttackEntity((Entity)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()));
                ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.getDirectEntity().position(), knockback);
                event.setCanceled(true);
                event.setResult(AttackResult.ResultType.BLOCKED);
            }
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.CLIENT)
    public void movementInputUpdateEvent(MappedMovementInputUpdateEvent event, SkillContainer skillContainer) {
        if (this.isActivated(skillContainer) && skillContainer.getExecutor().getAdvancedHoldingItemCapability(InteractionHand.MAIN_HAND).getInnateSkill(skillContainer.getExecutor(), ((Player)skillContainer.getExecutor().getOriginal()).getMainHandItem()) == this) {
            LocalPlayer clientPlayer = (LocalPlayer)skillContainer.getClientExecutor().getOriginal();
            clientPlayer.setSprinting(false);
            clientPlayer.sprintTriggerTime = -1;
            ControlEngine.setSprintingKeyStateNotDown();
        }
    }

    @Override
    public void executeOnServer(SkillContainer container, CompoundTag arguments) {
        container.getExecutor().playSound((Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, 0.0f, 0.0f);
        if (this.isActivated(container)) {
            this.cancelOnServer(container, arguments);
        } else {
            super.executeOnServer(container, arguments);
            container.activate();
            container.getServerExecutor().modifyLivingMotionByCurrentItem(false);
            container.getExecutor().playAnimationSynchronized(Animations.BIPED_LIECHTENAUER_READY, 0.0f);
        }
    }

    @Override
    public void cancelOnServer(SkillContainer container, CompoundTag arguments) {
        container.deactivate();
        super.cancelOnServer(container, arguments);
        container.getServerExecutor().modifyLivingMotionByCurrentItem(false);
    }

    @Override
    public void executeOnClient(SkillContainer container, CompoundTag arguments) {
        super.executeOnClient(container, arguments);
        container.activate();
    }

    @Override
    public void cancelOnClient(SkillContainer container, CompoundTag arguments) {
        super.cancelOnClient(container, arguments);
        container.deactivate();
    }

    @Override
    public boolean canExecute(SkillContainer container) {
        if (container.getExecutor().isLogicalClient()) {
            return super.canExecute(container);
        }
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).getMainHandItem();
        return EpicFightCapabilities.getItemStackCapability(itemstack).getInnateSkill(container.getExecutor(), itemstack) == this && ((Player)container.getExecutor().getOriginal()).getVehicle() == null;
    }

    @Override
    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    private static boolean isBlockableSource(DamageSource damageSource) {
        return !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !damageSource.is(DamageTypeTags.IS_EXPLOSION);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltipOnItem(ItemStack itemstack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        ArrayList list = Lists.newArrayList();
        ArrayList tooltipArgs = Lists.newArrayList();
        String traslatableText = this.getTranslationKey();
        tooltipArgs.add(this.maxDuration / 20);
        tooltipArgs.add(this.returnDuration / 20);
        list.add(Component.translatable((String)traslatableText).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)String.format("[%.0f]", Float.valueOf(this.consumption))).withStyle(ChatFormatting.AQUA)));
        list.add(Component.translatable((String)(traslatableText + ".tooltip"), (Object[])tooltipArgs.toArray(new Object[0])).withStyle(ChatFormatting.DARK_GRAY));
        return list;
    }

    public static enum Stance {
        VOM_TAG,
        PFLUG,
        OCHS;

    }
}

