/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.joml.Quaternionf;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.mixin.common.MixinWitherBossAccessor;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.registry.entries.EpicFightExpandedEntityDataAccessors;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.boss.BossPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.DroppedNetherStar;
import yesman.epicfight.world.entity.WitherGhostClone;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.data.ExpandedEntityDataAccessor;
import yesman.epicfight.world.entity.data.ExpandedSyncedData;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class WitherPatch
extends MobPatch<WitherBoss>
implements BossPatch<WitherBoss> {
    private static final List<DeferredHolder<ExpandedEntityDataAccessor<?>, ExpandedEntityDataAccessor<Vec3>>> DATA_LASER_TARGET_LOCATION_LIST = ImmutableList.of(EpicFightExpandedEntityDataAccessors.WITHER_HEAD_LEFT_TARGET_LOCATION, EpicFightExpandedEntityDataAccessors.WITHER_HEAD_CENTER_TARGET_LOCATION, EpicFightExpandedEntityDataAccessors.WITHER_HEAD_RIGHT_TARGET_LOCATION);
    private static final List<DeferredHolder<ExpandedEntityDataAccessor<?>, ExpandedEntityDataAccessor<Integer>>> DATA_TARGET_ENTITY_ID_LIST = ImmutableList.of(EpicFightExpandedEntityDataAccessors.WITHER_HEAD_LEFT_TARGET_ENTITY_ID, EpicFightExpandedEntityDataAccessors.WITHER_HEAD_CENTER_TARGET_ENTITY_ID, EpicFightExpandedEntityDataAccessors.WITHER_HEAD_RIGHT_TARGET_ENTITY_ID);
    public static final TargetingConditions WTIHER_GHOST_TARGETING_CONDITIONS = WitherBoss.TARGETING_CONDITIONS.copy().ignoreLineOfSight();
    private boolean blockedNow;
    private int deathTimerExt;
    private int blockingCount;
    private int blockingStartTick;
    private LivingEntityPatch<?> blockingEntity;

    public WitherPatch(WitherBoss entity) {
        super(entity);
    }

    @Override
    protected void registerExpandedEntityDataAccessors(ExpandedSyncedData expandedSynchedData) {
        super.registerExpandedEntityDataAccessors(expandedSynchedData);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.WITHER_ARMOR_ACTIVATED);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.WITHER_GHOST_MODE);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.WITHER_TRANSPARENCY);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.WITHER_HEAD_LEFT_TARGET_LOCATION);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.WITHER_HEAD_CENTER_TARGET_LOCATION);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.WITHER_HEAD_RIGHT_TARGET_LOCATION);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.WITHER_HEAD_LEFT_TARGET_ENTITY_ID);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.WITHER_HEAD_CENTER_TARGET_ENTITY_ID);
        expandedSynchedData.register((Holder<ExpandedEntityDataAccessor<?>>)EpicFightExpandedEntityDataAccessors.WITHER_HEAD_RIGHT_TARGET_ENTITY_ID);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        this.recordBossEventOwner(trackingPlayer);
    }

    @Override
    public void onStopTracking(ServerPlayer trackingPlayer) {
        this.removeBossEventOwner(trackingPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void entityPairing(SPEntityPairingPacket packet) {
        super.entityPairing(packet);
        if (packet.pairingPacketType() == EntityPairingPacketTypes.SET_BOSS_EVENT_OWNER) {
            this.processOwnerRecordPacket(packet.buffer());
        }
    }

    @Override
    public void initAI() {
        super.initAI();
        ((WitherBoss)this.original).goalSelector.addGoal(1, (Goal)new WitherChasingGoal());
        ((WitherBoss)this.original).goalSelector.addGoal(0, (Goal)new WitherGhostAttackGoal());
        ((WitherBoss)this.original).goalSelector.addGoal(0, new AnimatedAttackGoal<WitherPatch>(this, MobCombatBehaviors.WITHER.build(this)));
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.WITHER, EpicFightAttributes.IMPACT, 3.0);
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.WITHER_IDLE);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.WITHER_DEATH);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((WitherBoss)this.original).getHealth() <= 0.0f ? LivingMotions.DEATH : LivingMotions.IDLE;
    }

    @Override
    public void preTick(EntityTickEvent.Pre event) {
        if (((WitherBoss)this.original).getHealth() <= 0.0f && ((WitherBoss)this.original).deathTime > 1 && this.deathTimerExt < 17) {
            ++this.deathTimerExt;
            --((WitherBoss)this.original).deathTime;
        }
        if (!this.getEntityState().inaction()) {
            int targetId = ((WitherBoss)this.original).getAlternativeTarget(0);
            Entity target = ((WitherBoss)this.original).level().getEntity(targetId);
            if (target != null) {
                Vec3 vec3 = target.position().subtract(((WitherBoss)this.original).position()).normalize();
                float yrot = MathUtils.rotlerp(((WitherBoss)this.original).getYRot(), (float)Mth.atan2((double)vec3.z, (double)vec3.x) * 57.295776f - 90.0f, 10.0f);
                ((WitherBoss)this.original).setYRot(yrot);
            }
        }
        super.preTick(event);
    }

    @Override
    public void poseTick(DynamicAnimation animation, Pose pose, float time, float partialTicks) {
        MixinWitherBossAccessor originalAccessor = this.getOriginalAsMixinAccessor();
        if (pose.hasTransform("Head_M")) {
            float headRotO = ((WitherBoss)this.original).yBodyRotO - ((WitherBoss)this.original).yHeadRotO;
            float headRot = ((WitherBoss)this.original).yBodyRot - ((WitherBoss)this.original).yHeadRot;
            float partialHeadRot = MathUtils.lerpBetween(headRotO, headRot, partialTicks);
            Quaternionf headRotation = OpenMatrix4f.createRotatorDeg(-((WitherBoss)this.original).getXRot(), Vec3f.X_AXIS).mulFront(OpenMatrix4f.createRotatorDeg(partialHeadRot, Vec3f.Y_AXIS)).toQuaternion();
            pose.orElseEmpty("Head_M").frontResult(JointTransform.rotation(headRotation), OpenMatrix4f::mul);
        }
        if (pose.hasTransform("Head_R")) {
            float rightHeadYRot = Mth.rotLerp((float)partialTicks, (float)((WitherBoss)this.original).yBodyRotO, (float)((WitherBoss)this.original).yBodyRot) - Mth.rotLerp((float)partialTicks, (float)originalAccessor.getYRotOHeads()[1], (float)originalAccessor.getYRotHeads()[1]);
            float rightHeadXRot = Mth.rotLerp((float)partialTicks, (float)originalAccessor.getXRotOHeads()[1], (float)originalAccessor.getXRotHeads()[1]);
            Quaternionf headRotation = OpenMatrix4f.createRotatorDeg(rightHeadYRot, Vec3f.Y_AXIS).rotateDeg(-rightHeadXRot, Vec3f.X_AXIS).toQuaternion();
            pose.orElseEmpty("Head_R").frontResult(JointTransform.rotation(headRotation), OpenMatrix4f::mul);
        }
        if (pose.hasTransform("Head_L")) {
            float leftHeadYRot = Mth.rotLerp((float)partialTicks, (float)((WitherBoss)this.original).yBodyRotO, (float)((WitherBoss)this.original).yBodyRot) - Mth.rotLerp((float)partialTicks, (float)originalAccessor.getYRotOHeads()[0], (float)originalAccessor.getYRotHeads()[0]);
            float leftHeadXRot = Mth.rotLerp((float)partialTicks, (float)originalAccessor.getXRotOHeads()[0], (float)originalAccessor.getXRotHeads()[0]);
            Quaternionf headRotation = OpenMatrix4f.createRotatorDeg(leftHeadYRot, Vec3f.Y_AXIS).rotateDeg(-leftHeadXRot, Vec3f.X_AXIS).toQuaternion();
            pose.orElseEmpty("Head_L").frontResult(JointTransform.rotation(headRotation), OpenMatrix4f::mul);
        }
    }

    @Override
    public void preTickClient(EntityTickEvent.Pre event) {
        super.preTickClient(event);
        ((WitherBoss)this.original).setDeltaMovement(0.0, 0.0, 0.0);
        int transparencyCount = this.getTransparency();
        if (transparencyCount != 0) {
            this.setTransparency(transparencyCount + (transparencyCount > 0 ? -1 : 1));
        }
    }

    @Override
    public void preTickServer(EntityTickEvent.Pre event) {
        super.preTickServer(event);
        if (((WitherBoss)this.original).getHealth() <= ((WitherBoss)this.original).getMaxHealth() * 0.5f) {
            if (!this.isArmorActivated() && !this.getEntityState().inaction() && ((WitherBoss)this.original).getInvulnerableTicks() <= 0 && ((WitherBoss)this.original).isAlive()) {
                this.playAnimationSynchronized(Animations.WITHER_SPELL_ARMOR, 0.0f);
            }
        } else if (this.isArmorActivated()) {
            this.setArmorActivated(false);
        }
        if (this.animator.getPlayerFor(null).getAnimation().equals(Animations.WITHER_CHARGE) && this.getEntityState().attacking() && EventHooks.canEntityGrief((Level)((WitherBoss)this.original).level(), (Entity)this.original)) {
            int x = Mth.floor((double)((WitherBoss)this.original).getX());
            int y = Mth.floor((double)((WitherBoss)this.original).getY());
            int z = Mth.floor((double)((WitherBoss)this.original).getZ());
            boolean flag = false;
            for (int j = -1; j <= 1; ++j) {
                for (int k2 = -1; k2 <= 1; ++k2) {
                    for (int k = 0; k <= 3; ++k) {
                        int l2 = x + j;
                        int l = y + k;
                        int i1 = z + k2;
                        BlockPos blockpos = new BlockPos(l2, l, i1);
                        BlockState blockstate = ((WitherBoss)this.original).level().getBlockState(blockpos);
                        if (!blockstate.canEntityDestroy((BlockGetter)((WitherBoss)this.original).level(), blockpos, this.original) || !EventHooks.onEntityDestroyBlock((LivingEntity)((LivingEntity)this.original), (BlockPos)blockpos, (BlockState)blockstate)) continue;
                        flag = ((WitherBoss)this.original).level().destroyBlock(blockpos, true, this.original) || flag;
                    }
                }
            }
            if (flag) {
                ((WitherBoss)this.original).level().levelEvent(null, 1022, ((WitherBoss)this.original).blockPosition(), 0);
            }
        }
        if (this.blockedNow) {
            if (this.blockingCount < 0) {
                this.playAnimationSynchronized(Animations.WITHER_NEUTRALIZED, 0.0f);
                ((WitherBoss)this.original).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_BOSSES.get(), 5.0f, 1.0f);
                this.blockedNow = false;
                this.blockingEntity = null;
            } else if (((WitherBoss)this.original).tickCount % 4 == (this.blockingStartTick - 1) % 4) {
                if (((WitherBoss)this.original).position().distanceToSqr(((LivingEntity)this.blockingEntity.getOriginal()).position()) < 9.0) {
                    EpicFightDamageSource extendedSource = this.getDamageSource(Animations.WITHER_CHARGE, InteractionHand.MAIN_HAND);
                    extendedSource.setStunType(StunType.KNOCKDOWN).setBaseImpact(4.0f).setInitialPosition(this.lastAttackPosition);
                    AttackResult attackResult = this.tryHarm((Entity)this.blockingEntity.getOriginal(), extendedSource, this.blockingCount);
                    if (attackResult.resultType == AttackResult.ResultType.SUCCESS) {
                        ((LivingEntity)this.blockingEntity.getOriginal()).hurt((DamageSource)extendedSource, 4.0f);
                        this.blockedNow = false;
                        this.blockingEntity = null;
                    }
                } else {
                    this.blockedNow = false;
                    this.blockingEntity = null;
                }
            }
        }
    }

    @Override
    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> opponent) {
        EpicFightDamageSource extendedDamageSource;
        if (damageSource instanceof EpicFightDamageSource && Animations.WITHER_CHARGE.equals((extendedDamageSource = (EpicFightDamageSource)damageSource).getAnimation())) {
            if (!this.blockedNow) {
                this.blockedNow = true;
                this.blockingStartTick = ((WitherBoss)this.original).tickCount;
                this.blockingEntity = opponent;
                this.playAnimationSynchronized(Animations.WITHER_BLOCKED, 0.0f);
            }
            --this.blockingCount;
            Vec3 lookAngle = ((LivingEntity)opponent.getOriginal()).getLookAngle();
            lookAngle = lookAngle.subtract(0.0, lookAngle.y, 0.0);
            lookAngle.scale(0.1);
            ((WitherBoss)this.original).setPos(((LivingEntity)opponent.getOriginal()).position().add(lookAngle));
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        Entity entity;
        AssetAccessor<? extends DynamicAnimation> animation = ((Animator)this.getAnimator()).getPlayerFor(null).getAnimation();
        if ((animation.equals(Animations.WITHER_CHARGE) || animation.equals(Animations.WITHER_BLOCKED)) && (entity = damageSource.getDirectEntity()) instanceof AbstractArrow) {
            return AttackResult.blocked(0.0f);
        }
        return super.tryHurt(damageSource, amount);
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        super.onDeath(event);
        if (!this.isLogicalClient() && ((WitherBoss)this.original).level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT) && EpicFightGameRules.EPIC_DROP.getRuleValue(((WitherBoss)this.original).level()).booleanValue()) {
            Vec3 startMovement = ((WitherBoss)this.original).getLookAngle().scale(0.4).add(0.0, 0.63, 0.0);
            DroppedNetherStar itemEntity = new DroppedNetherStar(((WitherBoss)this.original).level(), ((WitherBoss)this.original).position().add(0.0, (double)((WitherBoss)this.original).getBbHeight() * 0.5, 0.0), startMovement);
            ((WitherBoss)this.original).level().addFreshEntity((Entity)itemEntity);
        }
    }

    @Override
    public boolean onDrop(LivingDropsEvent event) {
        if (EpicFightGameRules.EPIC_DROP.getRuleValue(((WitherBoss)this.original).level()).booleanValue()) {
            event.getDrops().removeIf(itemEntity -> itemEntity.getItem().is(Items.NETHER_STAR));
        }
        return false;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float yRot;
        float prevYRot;
        Entity entity = ((WitherBoss)this.original).getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)entity;
            prevYRot = ridingEntity.yBodyRotO;
            yRot = ridingEntity.yBodyRot;
        } else {
            prevYRot = this.isLogicalClient() ? ((WitherBoss)this.original).yBodyRotO : ((WitherBoss)this.original).yRotO;
            yRot = this.isLogicalClient() ? ((WitherBoss)this.original).yBodyRot : ((WitherBoss)this.original).getYRot();
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prevYRot, yRot, partialTicks, 1.0f, 1.0f, 1.0f);
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    public void startCharging() {
        this.setLastAttackPosition();
        this.blockingCount = 3;
    }

    public void setArmorActivated(boolean set) {
        this.getExpandedSynchedData().set(EpicFightExpandedEntityDataAccessors.WITHER_ARMOR_ACTIVATED, set);
    }

    public boolean isArmorActivated() {
        return this.getExpandedSynchedData().get(EpicFightExpandedEntityDataAccessors.WITHER_ARMOR_ACTIVATED);
    }

    public void setGhost(boolean set) {
        this.getExpandedSynchedData().set(EpicFightExpandedEntityDataAccessors.WITHER_GHOST_MODE, set);
        ((WitherBoss)this.original).setNoGravity(set);
        this.setTransparency(set ? 40 : -40);
        ((WitherBoss)this.original).setInvisible(set);
    }

    public boolean isGhost() {
        return this.getExpandedSynchedData().get(EpicFightExpandedEntityDataAccessors.WITHER_GHOST_MODE);
    }

    public void setTransparency(int set) {
        this.getExpandedSynchedData().set(EpicFightExpandedEntityDataAccessors.WITHER_TRANSPARENCY, set);
    }

    public int getTransparency() {
        return this.getExpandedSynchedData().get(EpicFightExpandedEntityDataAccessors.WITHER_TRANSPARENCY);
    }

    public void setLaserTargetPosition(int head, Vec3 pos) {
        this.getExpandedSynchedData().set(DATA_LASER_TARGET_LOCATION_LIST.get(head), pos);
    }

    public Vec3 getLaserTargetPosition(int head) {
        return this.getExpandedSynchedData().get(DATA_LASER_TARGET_LOCATION_LIST.get(head));
    }

    public void setLaserTarget(int head, Entity target) {
        this.getExpandedSynchedData().set(DATA_TARGET_ENTITY_ID_LIST.get(head), target != null ? target.getId() : -1);
    }

    public Entity getLaserTargetEntity(int head) {
        int laserTarget = this.getExpandedSynchedData().get(DATA_TARGET_ENTITY_ID_LIST.get(head));
        return laserTarget > 0 ? ((WitherBoss)this.original).level().getEntity(laserTarget) : null;
    }

    public Entity getAlternativeTargetEntity(int head) {
        int id = ((WitherBoss)this.original).getAlternativeTarget(head);
        return id > 0 ? ((WitherBoss)this.original).level().getEntity(id) : null;
    }

    public double getHeadX(int index) {
        if (index <= 0) {
            return ((WitherBoss)this.original).getX();
        }
        float f = (((WitherBoss)this.original).getYRot() + (float)(180 * (index - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.cos((float)f);
        return ((WitherBoss)this.original).getX() + (double)f1 * 1.3;
    }

    public double getHeadY(int index) {
        return index <= 0 ? ((WitherBoss)this.original).getY() + 3.0 : ((WitherBoss)this.original).getY() + 2.2;
    }

    public double getHeadZ(int index) {
        if (index <= 0) {
            return ((WitherBoss)this.original).getZ();
        }
        float f = (((WitherBoss)this.original).getYRot() + (float)(180 * (index - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.sin((float)f);
        return ((WitherBoss)this.original).getZ() + (double)f1 * 1.3;
    }

    @Override
    public BossEvent getBossEvent() {
        return this.getOriginalAsMixinAccessor().getBossEvent();
    }

    public MixinWitherBossAccessor getOriginalAsMixinAccessor() {
        return (MixinWitherBossAccessor)this.original;
    }

    public class WitherChasingGoal
    extends Goal {
        public WitherChasingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return ((WitherBoss)WitherPatch.this.original).getAlternativeTarget(0) > 0;
        }

        public void tick() {
            WitherBoss witherBoss = (WitherBoss)WitherPatch.this.getOriginal();
            Vec3 vec3 = witherBoss.getDeltaMovement().multiply(1.0, 0.6, 1.0);
            Entity entity = witherBoss.level().getEntity(((WitherBoss)WitherPatch.this.original).getAlternativeTarget(0));
            if (!WitherPatch.this.getEntityState().hurt() && !WitherPatch.this.blockedNow) {
                if (entity != null) {
                    double followingRange;
                    Vec3 vec31 = new Vec3(entity.getX() - witherBoss.getX(), 0.0, entity.getZ() - witherBoss.getZ());
                    double d0 = vec3.y;
                    if (witherBoss.getY() < entity.getY() || !witherBoss.isPowered() && witherBoss.getY() < entity.getY() + 5.0 && !((Animator)WitherPatch.this.getAnimator()).getPlayerFor(null).getAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false).booleanValue()) {
                        d0 = Math.max(0.0, d0);
                        d0 += 0.3 - d0 * (double)0.6f;
                    }
                    vec3 = new Vec3(vec3.x, d0, vec3.z);
                    double d = followingRange = witherBoss.isPowered() ? 9.0 : 49.0;
                    if (vec31.horizontalDistanceSqr() > followingRange && !WitherPatch.this.getEntityState().inaction()) {
                        Vec3 vec32 = vec31.normalize();
                        vec3 = vec3.add(vec32.x * 0.3 - vec3.x * 0.6, 0.0, vec32.z * 0.3 - vec3.z * 0.6);
                    }
                }
                witherBoss.setDeltaMovement(vec3);
            }
        }
    }

    public class WitherGhostAttackGoal
    extends Goal {
        private int ghostSummonCount;
        private int maxGhostSpawn;
        private int summonInverval;
        private int cooldown;

        public WitherGhostAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return --this.cooldown < 0 && WitherPatch.this.isArmorActivated() && !WitherPatch.this.getEntityState().inaction() && ((WitherBoss)WitherPatch.this.original).getTarget() != null;
        }

        public boolean canContinueToUse() {
            return this.ghostSummonCount <= this.maxGhostSpawn;
        }

        public void start() {
            WitherPatch.this.playAnimationSynchronized(Animations.WITHER_GHOST_STANDBY, 0.0f);
            WitherPatch.this.updateEntityState();
            WitherPatch.this.setGhost(true);
            List<LivingEntity> nearbyEnemies = this.getNearbyTargets();
            this.ghostSummonCount = 0;
            this.summonInverval = 25;
            this.maxGhostSpawn = Mth.clamp((int)(nearbyEnemies.size() / 2), (int)2, (int)4);
        }

        public void tick() {
            if (--this.summonInverval <= 0) {
                LivingEntity target;
                if (this.ghostSummonCount < this.maxGhostSpawn) {
                    List<LivingEntity> nearbyEnemies = this.getNearbyTargets();
                    if (!nearbyEnemies.isEmpty()) {
                        LivingEntity randomTarget = nearbyEnemies.get(((WitherBoss)WitherPatch.this.original).getRandom().nextInt(nearbyEnemies.size()));
                        Vec3 summonPosition = randomTarget.position().add(new Vec3(0.0, 0.0, 6.0).yRot(((WitherBoss)WitherPatch.this.original).getRandom().nextFloat() * 360.0f));
                        WitherGhostClone ghostclone = new WitherGhostClone((ServerLevel)((WitherBoss)WitherPatch.this.original).level(), summonPosition, randomTarget);
                        ((WitherBoss)WitherPatch.this.original).level().addFreshEntity((Entity)ghostclone);
                    } else {
                        this.ghostSummonCount = this.maxGhostSpawn + 1;
                    }
                }
                ++this.ghostSummonCount;
                int n = this.summonInverval = this.ghostSummonCount < this.maxGhostSpawn ? 25 : 35;
                if (this.ghostSummonCount == this.maxGhostSpawn && (target = ((WitherBoss)WitherPatch.this.original).getTarget()) != null) {
                    Vec3 summonPosition = target.position().add(new Vec3(0.0, 0.0, 6.0).yRot(((WitherBoss)WitherPatch.this.original).getRandom().nextFloat() * 360.0f)).add(0.0, 5.0, 0.0);
                    ((WitherBoss)WitherPatch.this.original).setPos(summonPosition);
                    ((WitherBoss)WitherPatch.this.original).lookAt(EntityAnchorArgument.Anchor.FEET, ((WitherBoss)WitherPatch.this.original).getTarget().position());
                }
            }
        }

        public void stop() {
            this.cooldown = 300;
            if (((WitherBoss)WitherPatch.this.original).getTarget() != null) {
                WitherPatch.this.playSound(SoundEvents.WITHER_AMBIENT, -0.1f, 0.1f);
                WitherPatch.this.playAnimationSynchronized(Animations.WITHER_CHARGE, 0.0f);
            } else {
                WitherPatch.this.playAnimationSynchronized(Animations.OFF_ANIMATION_HIGHEST, 0.0f);
            }
            WitherPatch.this.setGhost(false);
        }

        public List<LivingEntity> getNearbyTargets() {
            return ((WitherBoss)WitherPatch.this.original).level().getNearbyEntities(LivingEntity.class, WTIHER_GHOST_TARGETING_CONDITIONS, (LivingEntity)WitherPatch.this.original, ((WitherBoss)WitherPatch.this.original).getBoundingBox().inflate(20.0, 5.0, 20.0));
        }
    }
}

