/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.DragonArmature;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;
import yesman.epicfight.world.entity.AreaEffectBreath;

public class DragonAirstrikePhase
extends PatchedDragonPhase {
    private Vec3 startpos;
    private boolean isActuallyAttacking;

    public DragonAirstrikePhase(EnderDragon dragon) {
        super(dragon);
    }

    public void begin() {
        this.startpos = this.dragon.position();
        this.isActuallyAttacking = false;
        this.dragon.level().playLocalSound(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ(), SoundEvents.ENDER_DRAGON_GROWL, this.dragon.getSoundSource(), 5.0f, 0.8f + this.dragon.getRandom().nextFloat() * 0.3f, false);
    }

    public void end() {
        this.dragonpatch.setAttakTargetSync(null);
        if (this.dragonpatch.isLogicalClient()) {
            Minecraft.getInstance().getSoundManager().stop(((SoundEvent)EpicFightSounds.ENDER_DRAGON_BREATH.get()).getLocation(), SoundSource.HOSTILE);
            this.dragon.level().playLocalSound(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ(), (SoundEvent)EpicFightSounds.ENDER_DRAGON_BREATH_FINALE.get(), this.dragon.getSoundSource(), 5.0f, 1.0f, false);
        }
    }

    @Override
    public void doClientTick() {
        super.doClientTick();
        Vec3 dragonpos = this.dragon.position();
        OpenMatrix4f mouthpos = this.dragonpatch.getArmature().getBoundTransformFor(((Animator)this.dragonpatch.getAnimator()).getPose(1.0f), ((DragonArmature)Armatures.DRAGON.get()).upperMouth);
        float f = (float)this.dragon.getLatencyPos(7, 1.0f)[0];
        float f1 = (float)(this.dragon.getLatencyPos(5, 1.0f)[1] - this.dragon.getLatencyPos(10, 1.0f)[1]);
        float f2 = MathUtils.rotWrap(this.dragon.getLatencyPos(5, 1.0f)[0] - this.dragon.getLatencyPos(10, 1.0f)[0]);
        OpenMatrix4f modelMatrix = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f1, f1, f, f, 1.0f, 1.0f, 1.0f, 1.0f).rotateDeg(-f2 * 1.5f, Vec3f.Z_AXIS);
        mouthpos.mulFront(modelMatrix);
        if (this.dragon.getTarget() != null) {
            Vec3 vec31 = this.dragon.getTarget().position().add(0.0, 12.0, 0.0);
            if (!this.isActuallyAttacking && vec31.subtract(this.dragon.position()).lengthSqr() < 900.0) {
                this.dragon.level().playLocalSound(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ(), (SoundEvent)EpicFightSounds.ENDER_DRAGON_BREATH.get(), this.dragon.getSoundSource(), 5.0f, 1.0f, false);
                this.isActuallyAttacking = true;
            }
        }
        if (this.isActuallyAttacking) {
            for (int i = 0; i < 60; ++i) {
                Vec3f particleDelta = new Vec3f(0.0f, -1.0f, 0.0f);
                float xDeg = this.dragon.getRandom().nextFloat() * 60.0f - 30.0f;
                float zDeg = this.dragon.getRandom().nextFloat() * 60.0f - 30.0f;
                float speed = Math.min((60.0f - (Math.abs(xDeg) + Math.abs(zDeg))) / 20.0f, 1.0f);
                particleDelta.rotate(xDeg, Vec3f.X_AXIS);
                particleDelta.rotate(zDeg, Vec3f.Z_AXIS);
                particleDelta.scale(speed);
                this.dragon.level().addAlwaysVisibleParticle((ParticleOptions)EpicFightParticles.BREATH_FLAME.get(), (double)mouthpos.m30 + dragonpos.x, (double)mouthpos.m31 + dragonpos.y, (double)mouthpos.m32 + dragonpos.z, (double)particleDelta.x, (double)particleDelta.y, (double)particleDelta.z);
            }
        }
    }

    public void doServerTick() {
        LivingEntity target = this.dragon.getTarget();
        if (target == null) {
            this.dragon.getPhaseManager().setPhase(PatchedPhases.FLYING);
        } else if (DragonAirstrikePhase.isValidTarget(target)) {
            Vec3 startToDragon = this.dragon.position().subtract(this.startpos);
            Vec3 startToTarget = target.position().subtract(this.startpos);
            if (startToDragon.horizontalDistanceSqr() < startToTarget.horizontalDistanceSqr()) {
                Vec3 vec31 = target.position().add(0.0, 12.0, 0.0);
                if (!this.isActuallyAttacking && vec31.subtract(this.dragon.position()).lengthSqr() < 900.0) {
                    this.isActuallyAttacking = true;
                }
                double d8 = vec31.x - this.dragon.getX();
                double d9 = vec31.y - this.dragon.getY();
                double d10 = vec31.z - this.dragon.getZ();
                float f5 = this.getFlySpeed();
                double d4 = Math.sqrt(d8 * d8 + d10 * d10);
                if (d4 > 0.0) {
                    d9 = Mth.clamp((double)(d9 / d4), (double)(-f5), (double)f5);
                }
                this.dragon.setDeltaMovement(this.dragon.getDeltaMovement().add(0.0, d9 * 0.1, 0.0));
                this.dragon.setYRot(Mth.wrapDegrees((float)this.dragon.getYRot()));
                Vec3 vec32 = vec31.subtract(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ()).normalize();
                Vec3 vec33 = new Vec3((double)Mth.sin((float)(this.dragon.getYRot() * ((float)Math.PI / 180))), this.dragon.getDeltaMovement().y, (double)(-Mth.cos((float)(this.dragon.getYRot() * ((float)Math.PI / 180))))).normalize();
                float f6 = Math.max(((float)vec33.dot(vec32) + 0.5f) / 1.5f, 0.0f);
                if (Math.abs(d8) > (double)1.0E-5f || Math.abs(d10) > (double)1.0E-5f) {
                    double dx = target.getX() - this.dragon.getX();
                    double dz = target.getZ() - this.dragon.getZ();
                    float yRot = 180.0f - (float)Math.toDegrees(Mth.atan2((double)dx, (double)dz));
                    this.dragon.setYRot(MathUtils.rotlerp(this.dragon.getYRot(), yRot, 6.0f));
                    double speed = (-0.5 - 1.0 / (1.0 + Math.pow(Math.E, -(d4 / 10.0 - 4.0)))) * (double)f6;
                    Vec3 forward = this.dragon.getForward().scale(speed);
                    this.dragon.move(MoverType.SELF, forward);
                }
                if (this.dragon.inWall) {
                    this.dragon.move(MoverType.SELF, this.dragon.getDeltaMovement().scale((double)0.8f));
                } else {
                    this.dragon.move(MoverType.SELF, this.dragon.getDeltaMovement());
                }
                Vec3 vec34 = this.dragon.getDeltaMovement().normalize();
                double d6 = 0.8 + 0.15 * (vec34.dot(vec33) + 1.0) / 2.0;
                this.dragon.setDeltaMovement(this.dragon.getDeltaMovement().multiply(d6, (double)0.91f, d6));
                if (this.isActuallyAttacking && this.dragon.tickCount % 5 == 0) {
                    Vec3 createpos = this.dragon.position().add(this.dragon.getLookAngle().scale(-4.5));
                    AreaEffectBreath breatharea = new AreaEffectBreath(this.dragon.level(), createpos.x, createpos.y, createpos.z);
                    breatharea.setOwner((LivingEntity)this.dragon);
                    breatharea.setWaitTime(0);
                    breatharea.setRadius(0.5f);
                    breatharea.setDuration(15);
                    breatharea.setRadiusPerTick(0.2f);
                    breatharea.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
                    breatharea.setDeltaMovement(0.0, -1.0, 0.0);
                    this.dragon.level().addFreshEntity((Entity)breatharea);
                }
            } else {
                this.dragon.getPhaseManager().setPhase(PatchedPhases.FLYING);
            }
        } else {
            this.dragon.getPhaseManager().setPhase(PatchedPhases.FLYING);
        }
    }

    public boolean isActuallyAttacking() {
        return this.isActuallyAttacking;
    }

    public float getFlySpeed() {
        return 2.0f;
    }

    public EnderDragonPhase<? extends DragonPhaseInstance> getPhase() {
        return PatchedPhases.AIRSTRIKE;
    }
}

