/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.projectile;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public abstract class ProjectilePatch<T extends Projectile>
extends EntityPatch<T> {
    protected float impact;
    protected float armorNegation;
    protected Vec3 initialFirePosition;
    protected boolean hasHit;

    public ProjectilePatch(T original) {
        super(original);
    }

    @Override
    public void onJoinWorld(T projectileEntity, EntityJoinLevelEvent event) {
        Entity shooter = projectileEntity.getOwner();
        boolean flag = true;
        if (shooter != null && shooter instanceof LivingEntity) {
            LivingEntity livingshooter = (LivingEntity)shooter;
            this.initialFirePosition = shooter.position();
            ItemStack heldItem = livingshooter.getMainHandItem();
            CapabilityItem itemCap = EpicFightCapabilities.getItemStackCapability(heldItem);
            if (itemCap instanceof RangedWeaponCapability) {
                Map<Holder<Attribute>, AttributeModifier> modifierMap = itemCap.getDamageAttributesInCondition(CapabilityItem.Styles.RANGED);
                if (modifierMap != null) {
                    this.armorNegation = modifierMap.containsKey(EpicFightAttributes.ARMOR_NEGATION) ? (float)modifierMap.get(EpicFightAttributes.ARMOR_NEGATION).amount() : (float)((Attribute)EpicFightAttributes.ARMOR_NEGATION.value()).getDefaultValue();
                    float f = this.impact = modifierMap.containsKey(EpicFightAttributes.IMPACT) ? (float)modifierMap.get(EpicFightAttributes.IMPACT).amount() : (float)((Attribute)EpicFightAttributes.IMPACT.value()).getDefaultValue();
                    if (modifierMap.containsKey(EpicFightAttributes.MAX_STRIKES)) {
                        this.setMaxStrikes(projectileEntity, (int)modifierMap.get(EpicFightAttributes.MAX_STRIKES).amount());
                    }
                }
                flag = false;
            }
        }
        if (flag) {
            this.armorNegation = 0.0f;
            this.impact = 0.0f;
        }
    }

    @Override
    public void onAddedToLevel() {
        if (((Projectile)this.getOriginal()).level().isClientSide()) {
            double entityId = Double.longBitsToDouble(((Projectile)this.getOriginal()).getId());
            ((Projectile)this.getOriginal()).level().addParticle((ParticleOptions)EpicFightParticles.PROJECTILE_TRAIL.get(), entityId, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean onProjectileImpact(ProjectileImpactEvent event) {
        return false;
    }

    protected abstract void setMaxStrikes(T var1, int var2);

    public abstract EpicFightDamageSource createEpicFightDamageSource();

    @Override
    public boolean overrideRender() {
        return false;
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return super.getMatrix(partialTicks);
    }

    public void setHit(boolean hit) {
        this.hasHit = hit;
    }

    public boolean hit() {
        return this.hasHit;
    }
}

