/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WindParticle
extends TextureSheetParticle {
    private final double rollSpeed;
    private boolean hasHitGround;

    WindParticle(ClientLevel clientLevel, double x, double y, double z, double dx, double dy, double dz) {
        super(clientLevel, x, y, z);
        this.friction = 0.998f;
        this.quadSize = (float)((double)this.quadSize * ((double)0.8f + (Math.random() * 2.0 - 1.0) * (double)0.4f));
        this.lifetime = (int)(14.0 / ((double)this.random.nextFloat() * 0.8 + 0.2));
        this.hasHitGround = false;
        this.hasPhysics = true;
        this.xd = dx;
        this.yd = dy;
        this.zd = dz;
        this.xd += (Math.random() * 2.0 - 1.0) * (double)0.03f;
        this.yd += (Math.random() * 2.0 - 1.0) * (double)0.03f;
        this.zd += (Math.random() * 2.0 - 1.0) * (double)0.03f;
        this.rollSpeed = 0.35 + Math.random() * 0.2;
        if (Math.random() < 0.5) {
            // empty if block
        }
    }

    public void tick() {
        this.oRoll = this.roll;
        this.roll = (float)((double)this.roll + this.rollSpeed);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            boolean wasOnGround = this.hasHitGround;
            if (this.onGround) {
                this.yd = 0.0;
                this.hasHitGround = true;
            }
            if (this.hasHitGround != wasOnGround) {
                this.xd += (double)(this.random.nextFloat() * 0.04f);
                this.zd += (double)(this.random.nextFloat() * 0.04f);
                this.yd += 0.01;
            }
            this.yd = this.hasHitGround ? (this.yd += 0.002) : (this.yd += 0.001);
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= (double)this.friction;
            this.zd *= (double)this.friction;
            this.yd *= (double)this.friction;
            this.xd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            if ((float)this.age >= (float)this.lifetime / 3.0f && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)(0.3f + ((float)this.age + partialTicks) / (float)this.lifetime * 4.0f), (float)0.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            WindParticle p = new WindParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            p.pickSprite(this.sprites);
            return p;
        }
    }
}

