/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;

public class BiomeMatchPredicate
implements BlockPredicate {
    private final ResourceKey<Biome> biome;
    public static final MapCodec<BiomeMatchPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("biome").forGetter(hasSturdyFacePredicate -> hasSturdyFacePredicate.biome)).apply((Applicative)instance, BiomeMatchPredicate::new));

    public BiomeMatchPredicate(ResourceKey<Biome> biome) {
        this.biome = biome;
    }

    public boolean test(WorldGenLevel worldGenLevel, BlockPos blockPos) {
        return this.biome == worldGenLevel.getBiome(blockPos).unwrapKey().get();
    }

    public BlockPredicateType<?> type() {
        return (BlockPredicateType)MysticalOakTree.BIOME_MATCH_PREDICATE.get();
    }
}

