/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.worldgen;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class WiseOakDecorator
extends TreeDecorator {
    public static final WiseOakDecorator INSTANCE = new WiseOakDecorator();
    public static final MapCodec<WiseOakDecorator> CODEC = MapCodec.unit(() -> INSTANCE);

    private WiseOakDecorator() {
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)MysticalOakTree.WISE_OAK_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomSource = context.random();
        ObjectArrayList leaves = context.leaves();
        ObjectArrayList logs = context.logs();
        if (logs.size() > 2) {
            BlockPos pos = (BlockPos)logs.get(2);
            Direction chosen = null;
            ArrayList<Direction> leafAbove = new ArrayList<Direction>();
            ArrayList<Direction> logAbove = new ArrayList<Direction>();
            for (Direction d : Direction.Plane.HORIZONTAL.shuffledCopy(randomSource)) {
                if (leaves.contains(pos.relative(d))) continue;
                BlockPos above = pos.relative(d).above();
                if (logs.contains(above)) {
                    logAbove.add(d);
                    continue;
                }
                if (leaves.contains(above)) {
                    leafAbove.add(d);
                    continue;
                }
                chosen = d;
                break;
            }
            if (chosen == null) {
                if (!leafAbove.isEmpty()) {
                    chosen = (Direction)leafAbove.get(0);
                } else if (!logAbove.isEmpty()) {
                    chosen = (Direction)logAbove.get(0);
                }
            }
            if (chosen != null) {
                context.setBlock(pos, (BlockState)((BlockState)MysticalOakTree.BLOCK.get().defaultBlockState().setValue(WiseOakBlock.STATE, (Comparable)((Object)WiseOakBlock.State.SLEEPING))).setValue((Property)WiseOakBlock.FACING, (Comparable)chosen));
            }
        }
    }
}

