/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class WiseOakFeature
extends Feature<Configuration> {
    public WiseOakFeature() {
        super(Configuration.CODEC);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        Configuration config = (Configuration)context.config();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        ChunkGenerator generator = context.chunkGenerator();
        BlockPos pos = context.origin();
        Holder biome = level.getBiome(pos);
        Holder<PlacedFeature> feature = biome.is(Biomes.MANGROVE_SWAMP) ? config.mangrove : (biome.is(BiomeTags.HAS_SWAMP_HUT) || biome.is(BiomeTags.IS_JUNGLE) ? config.vines : config.main);
        if (((PlacedFeature)feature.value()).place(level, generator, randomSource, pos)) {
            ((PlacedFeature)config.flowers.value()).place(level, generator, randomSource, pos);
            return true;
        }
        return false;
    }

    public record Configuration(Holder<PlacedFeature> main, Holder<PlacedFeature> vines, Holder<PlacedFeature> mangrove, Holder<PlacedFeature> flowers) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PlacedFeature.CODEC.fieldOf("main_feature").forGetter(Configuration::main), (App)PlacedFeature.CODEC.fieldOf("vines_feature").forGetter(Configuration::vines), (App)PlacedFeature.CODEC.fieldOf("mangrove_feature").forGetter(Configuration::mangrove), (App)PlacedFeature.CODEC.fieldOf("flower_patch").forGetter(Configuration::flowers)).apply((Applicative)instance, Configuration::new));
    }
}

