/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.mojang.blaze3d.platform.InputConstants;
import dev.latvian.mods.kubejs.client.ClientKubeEvent;
import dev.latvian.mods.kubejs.client.KubeJSKeybinds;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.GLFWInputWrapper;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

public class KeybindRegistryKubeEvent
implements ClientKubeEvent {
    private final List<Builder> builders = new ArrayList<Builder>();

    public Builder register(String id) {
        Builder builder = new Builder(id);
        this.builders.add(builder);
        return builder;
    }

    public Builder register(String id, String defaultKey) {
        return this.register(id).defaultKey(defaultKey);
    }

    @HideFromJS
    public List<KubeJSKeybinds.KubeKey> build() {
        return this.builders.stream().map(Builder::create).toList();
    }

    public static class Builder {
        private final String id;
        private KeyConflictContext keyConflictContext = KeyConflictContext.UNIVERSAL;
        private KeyModifier modifier = KeyModifier.NONE;
        private InputConstants.Type inputType = InputConstants.Type.KEYSYM;
        private int defaultKey = -1;
        private String category = "key.categories.kubejs";

        private Builder(String id) {
            this.id = id;
        }

        public Builder conflictContext(KeyConflictContext keyConflictContext) {
            this.keyConflictContext = keyConflictContext;
            return this;
        }

        public Builder gui() {
            return this.conflictContext(KeyConflictContext.GUI);
        }

        public Builder inGame() {
            return this.conflictContext(KeyConflictContext.IN_GAME);
        }

        public Builder modifier(KeyModifier modifier) {
            this.modifier = modifier;
            return this;
        }

        public Builder inputType(InputConstants.Type inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder scanCodeInputType() {
            return this.inputType(InputConstants.Type.SCANCODE);
        }

        public Builder mouseInputType() {
            return this.inputType(InputConstants.Type.MOUSE);
        }

        public Builder defaultKey(String keyName) {
            this.defaultKey = GLFWInputWrapper.get(keyName);
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        @HideFromJS
        public KubeJSKeybinds.KubeKey create() {
            KubeJSKeybinds.KubeKey key = KubeJSKeybinds.getOrCreate(this.id);
            key.mapping = new KeyMapping("key.kubejs.%s".formatted(this.id), (IKeyConflictContext)this.keyConflictContext, this.modifier, this.inputType, this.defaultKey, this.category);
            return key;
        }
    }
}

