/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.highlight;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.client.highlight.HighlightKubeEvent;
import dev.latvian.mods.kubejs.color.KubeColor;
import dev.latvian.mods.kubejs.color.SimpleColor;
import dev.latvian.mods.kubejs.net.RequestBlockKubedexPayload;
import dev.latvian.mods.kubejs.net.RequestEntityKubedexPayload;
import dev.latvian.mods.kubejs.net.RequestInventoryKubedexPayload;
import dev.latvian.mods.kubejs.plugin.builtin.event.ClientEvents;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class HighlightRenderer {
    public static HighlightRenderer INSTANCE = new HighlightRenderer();
    public static KeyMapping keyMapping;
    public KubeColor color = new SimpleColor(10092467);
    public Mode mode = Mode.NONE;
    public boolean actualKey;
    @Nullable
    public ShaderChain worldChain;
    @Nullable
    public ShaderChain guiChain;
    @Nullable
    public ShaderInstance highlightShader;
    public final Set<Slot> hoveredSlots = new HashSet<Slot>();
    public final Reference2IntMap<Entity> highlightedEntities = new Reference2IntLinkedOpenHashMap(0);
    public final Long2IntMap highlightedBlocks = new Long2IntLinkedOpenHashMap(0);
    public final IntOpenHashSet uniqueColors = new IntOpenHashSet(0);
    public boolean cancelBlockHighlight;

    public void loadPostChains(Minecraft mc) {
        if (this.worldChain != null) {
            this.worldChain.close();
        }
        if (this.guiChain != null) {
            this.guiChain.close();
        }
        ResourceLocation id = ResourceLocation.withDefaultNamespace((String)"shaders/post/kubejs/highlight.json");
        this.worldChain = ShaderChain.load(mc, id);
        this.guiChain = ShaderChain.load(mc, id);
    }

    public void tickPre(Minecraft mc) {
        boolean prevKeyDown = this.actualKey;
        boolean bl = this.actualKey = mc.level != null && mc.player != null && keyMapping != null && !mc.isPaused() && mc.player.hasPermissions(2) && mc.kjs$isKeyMappingDown(keyMapping);
        while (this.actualKey && this.mode != Mode.NONE && mc.options.keyInventory.consumeClick()) {
            this.keyToggled(mc, Mode.NONE, false);
        }
        if (prevKeyDown != this.actualKey) {
            if (!this.actualKey) {
                this.keyToggled(mc, Mode.NONE, true);
            } else if (mc.screen != null) {
                this.keyToggled(mc, Mode.SCREEN, true);
            } else {
                this.keyToggled(mc, Mode.WORLD, true);
            }
        }
        this.highlightedEntities.clear();
        this.highlightedBlocks.clear();
        this.uniqueColors.clear();
        this.cancelBlockHighlight = false;
        if (mc.level != null && mc.player != null) {
            BlockHitResult hit;
            HitResult hitResult;
            HighlightKubeEvent event = new HighlightKubeEvent(mc, this);
            ClientEvents.HIGHLIGHT.post(event);
            if (this.mode == Mode.WORLD) {
                event.addTarget(this.color);
            }
            if ((hitResult = mc.hitResult) instanceof BlockHitResult && (hit = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK && this.highlightedBlocks.containsKey(hit.getBlockPos().asLong())) {
                this.cancelBlockHighlight = true;
            }
        }
    }

    private void playSound(Minecraft mc) {
        String sound = DevProperties.get().kubedexSound;
        if (!sound.isEmpty()) {
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.parse((String)sound)), (float)1.0f));
        }
    }

    private int getFlags() {
        int flags = 0;
        flags |= Screen.hasShiftDown() ? 1 : 0;
        flags |= Screen.hasControlDown() ? 2 : 0;
        return flags |= Screen.hasAltDown() ? 4 : 0;
    }

    private void requestBlock(BlockPos pos) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestBlockKubedexPayload(pos, this.getFlags()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void requestEntity(Entity entity) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestEntityKubedexPayload(entity.getId(), this.getFlags()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void requestInventory(Set<Slot> slots) {
        ArrayList<Integer> slotIds = new ArrayList<Integer>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Slot slot : slots) {
            if (slot.container instanceof Inventory) {
                slotIds.add(slot.getSlotIndex());
                continue;
            }
            ItemStack stack = slot.getItem();
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestInventoryKubedexPayload(slotIds, stacks, this.getFlags()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void keyToggled(Minecraft mc, Mode newMode, boolean success) {
        if (newMode == Mode.NONE) {
            if (this.mode == Mode.SCREEN) {
                if (success && !this.hoveredSlots.isEmpty()) {
                    this.playSound(mc);
                    this.requestInventory(this.hoveredSlots);
                }
                this.hoveredSlots.clear();
            } else if (success) {
                HitResult hitResult = mc.hitResult;
                if (hitResult instanceof EntityHitResult) {
                    EntityHitResult hit = (EntityHitResult)hitResult;
                    this.playSound(mc);
                    this.requestEntity(hit.getEntity());
                } else {
                    BlockHitResult hit;
                    hitResult = mc.hitResult;
                    if (hitResult instanceof BlockHitResult && (hit = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK) {
                        this.playSound(mc);
                        this.requestBlock(hit.getBlockPos());
                    }
                }
            }
        }
        this.mode = newMode;
    }

    public void clearBuffers(Minecraft mc) {
        if (this.worldChain != null) {
            this.worldChain.clearInput(mc);
        }
        if (this.guiChain != null) {
            this.guiChain.clearInput(mc);
        }
    }

    public void renderAfterLevel(Minecraft mc, RenderLevelStageEvent event) {
        this.updateDepth(mc);
        if (this.worldChain != null) {
            this.worldChain.draw(mc, event.getPartialTick().getGameTimeDeltaPartialTick(false));
        }
    }

    public void updateDepth(Minecraft mc) {
        if (this.worldChain != null) {
            this.worldChain.clearDepth(mc, true);
        }
        if (this.guiChain != null) {
            this.guiChain.clearDepth(mc, false);
        }
    }

    public void resizePostChains(int width, int height) {
        if (this.worldChain != null) {
            this.worldChain.postChain.resize(width, height);
        }
        if (this.guiChain != null) {
            this.guiChain.postChain.resize(width, height);
        }
    }

    public void renderAfterEntities(Minecraft mc, RenderLevelStageEvent event) {
        if (mc.level == null || this.worldChain == null || this.highlightShader == null || this.highlightedBlocks.isEmpty() && this.highlightedEntities.isEmpty()) {
            return;
        }
        mc.renderBuffers().bufferSource().endBatch();
        this.worldChain.renderInput.bindWrite(false);
        PoseStack ms = event.getPoseStack();
        Vec3 cam = event.getCamera().getPosition();
        float delta = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        ms.pushPose();
        ms.translate(-cam.x, -cam.y, -cam.z);
        Int2ObjectOpenHashMap sources = new Int2ObjectOpenHashMap();
        IntIterator intIterator = this.uniqueColors.iterator();
        while (intIterator.hasNext()) {
            int color = (Integer)intIterator.next();
            sources.put(color, (Object)new WrappedMultiBufferSource((MultiBufferSource)mc.renderBuffers().bufferSource(), color));
        }
        for (Long2IntMap.Entry entry : this.highlightedBlocks.long2IntEntrySet()) {
            BlockPos pos = BlockPos.of((long)entry.getLongKey());
            BlockState state = mc.level.getBlockState(pos);
            if (state.isAir()) continue;
            this.worldChain.renderAnything.setTrue();
            double x = pos.getX();
            double y = pos.getY();
            double z = pos.getZ();
            ms.pushPose();
            ms.translate(x, y, z);
            BakedModel model = mc.getBlockRenderer().getBlockModel(state);
            long seed = state.getSeed(pos);
            WrappedMultiBufferSource bufferSource = (WrappedMultiBufferSource)sources.get(entry.getIntValue());
            for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)seed), ModelData.EMPTY)) {
                mc.getBlockRenderer().getModelRenderer().tesselateBlock((BlockAndTintGetter)mc.level, model, state, pos, ms, bufferSource.getBuffer(RenderTypeHelper.getMovingBlockRenderType((RenderType)renderType)), false, RandomSource.create(), seed, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
            }
            BlockEntity entity = mc.level.getBlockEntity(pos);
            if (entity != null) {
                mc.getBlockEntityRenderDispatcher().render(entity, delta, ms, (MultiBufferSource)bufferSource);
            } else if (state.getRenderShape() == RenderShape.INVISIBLE) {
                VertexConsumer buf = bufferSource.getBuffer(RenderType.debugQuads());
                Matrix4f m = ms.last().pose();
                this.box(buf, m, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
            ms.popPose();
        }
        for (Reference2IntMap.Entry entry : this.highlightedEntities.reference2IntEntrySet()) {
            Entity entity = (Entity)entry.getKey();
            this.worldChain.renderAnything.setTrue();
            Vec3 p = entity.getPosition(delta);
            float yaw = Mth.lerp((float)delta, (float)entity.yRotO, (float)entity.getYRot());
            EntityRenderer renderer = mc.getEntityRenderDispatcher().getRenderer(entity);
            WrappedMultiBufferSource bufferSource = (WrappedMultiBufferSource)sources.get(entry.getIntValue());
            if (renderer != null) {
                Vec3 off = renderer.getRenderOffset(entity, delta);
                double x1 = p.x + off.x();
                double y1 = p.y + off.y();
                double z1 = p.z + off.z();
                ms.pushPose();
                ms.translate(x1, y1, z1);
                renderer.render(entity, yaw, delta, ms, (MultiBufferSource)bufferSource, 0xF000F0);
                ms.popPose();
                continue;
            }
            VertexConsumer buf = bufferSource.getBuffer(RenderType.debugQuads());
            ms.pushPose();
            ms.translate(p.x, p.y, p.z);
            Matrix4f m = ms.last().pose();
            float w = entity.getBbWidth() / 2.0f;
            this.box(buf, m, -w, 0.0f, -w, w, entity.getBbHeight(), w);
            ms.popPose();
        }
        ms.popPose();
        mc.renderBuffers().bufferSource().endBatch();
        mc.getMainRenderTarget().bindWrite(false);
    }

    private void box(VertexConsumer buf, Matrix4f m, float x0, float y0, float z0, float x1, float y1, float z1) {
        buf.addVertex(m, x0, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y0, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x0, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z0).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y1, z1).setColor(255, 255, 255, 255);
        buf.addVertex(m, x1, y0, z1).setColor(255, 255, 255, 255);
    }

    public void screen(Minecraft mc, GuiGraphics graphics, AbstractContainerScreen<?> screen, int mx, int my, float delta) {
        if (this.guiChain == null || this.highlightShader == null) {
            return;
        }
        while (this.actualKey && this.mode != Mode.NONE && mc.options.keyInventory.consumeClick()) {
            this.keyToggled(mc, Mode.NONE, false);
        }
        if (this.mode != Mode.SCREEN) {
            return;
        }
        AbstractContainerMenu menu = screen.getMenu();
        for (Slot slot : menu.slots) {
            int sx = slot.x + screen.getGuiLeft();
            int sy = slot.y + screen.getGuiTop();
            if (mx < sx || mx >= sx + 16 || my < sy || my >= sy + 16 || !slot.hasItem()) continue;
            this.hoveredSlots.add(slot);
        }
        if (this.hoveredSlots.isEmpty()) {
            return;
        }
        this.guiChain.renderAnything.setTrue();
        graphics.flush();
        this.guiChain.renderInput.bindWrite(false);
        WrappedMultiBufferSource bufferSource = new WrappedMultiBufferSource((MultiBufferSource)mc.renderBuffers().bufferSource(), this.color.kjs$getRGB());
        for (Slot slot : this.hoveredSlots) {
            int x = slot.x + screen.getGuiLeft();
            int y = slot.y + screen.getGuiTop();
            ItemStack stack = slot.getItem();
            BakedModel model = mc.getItemRenderer().getModel(stack, (Level)mc.level, (LivingEntity)mc.player, 0);
            graphics.pose().pushPose();
            graphics.pose().translate((float)x + 8.0f, (float)y + 8.0f, 0.0f);
            graphics.pose().scale(16.0f, -16.0f, 16.0f);
            try {
                ItemStack renderStack = stack.copy();
                renderStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)false);
                renderStack.setDamageValue(0);
                renderStack.setCount(1);
                mc.getItemRenderer().render(renderStack, ItemDisplayContext.GUI, false, graphics.pose(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
                crashreportcategory.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                throw new ReportedException(crashreport);
            }
            graphics.pose().popPose();
        }
        graphics.flush();
        mc.getMainRenderTarget().bindWrite(false);
        this.guiChain.draw(mc, delta);
    }

    public void hudPostDraw(Minecraft mc, GuiGraphics graphics, float delta) {
    }

    public static enum Mode {
        NONE,
        SCREEN,
        WORLD;

    }

    public record ShaderChain(PostChain postChain, RenderTarget renderInput, RenderTarget mcDepthInput, RenderTarget renderOutput, MutableBoolean renderAnything) {
        @Nullable
        public static ShaderChain load(Minecraft mc, ResourceLocation id) {
            try {
                PostChain postChain = new PostChain(mc.getTextureManager(), (ResourceProvider)mc.getResourceManager(), mc.getMainRenderTarget(), id);
                postChain.resize(mc.getWindow().getWidth(), mc.getWindow().getHeight());
                RenderTarget renderInput = postChain.getTempTarget("input");
                RenderTarget mcDepthInput = postChain.getTempTarget("mcdepth");
                RenderTarget renderOutput = postChain.getTempTarget("output");
                return new ShaderChain(postChain, renderInput, mcDepthInput, renderOutput, new MutableBoolean(false));
            }
            catch (IOException ex) {
                KubeJS.LOGGER.warn("Failed to load shader: {}", (Object)id, (Object)ex);
            }
            catch (JsonSyntaxException ex) {
                KubeJS.LOGGER.warn("Failed to parse shader: {}", (Object)id, (Object)ex);
            }
            return null;
        }

        public void close() {
            this.postChain.close();
        }

        public void clearInput(Minecraft mc) {
            this.renderInput.clear(Minecraft.ON_OSX);
            mc.getMainRenderTarget().bindWrite(false);
            this.renderAnything.setFalse();
        }

        public void clearDepth(Minecraft mc, boolean copy) {
            this.mcDepthInput.clear(Minecraft.ON_OSX);
            if (copy) {
                this.mcDepthInput.copyDepthFrom(mc.getMainRenderTarget());
            }
            mc.getMainRenderTarget().bindWrite(false);
        }

        public void draw(Minecraft mc, float delta) {
            if (this.renderAnything.isFalse()) {
                return;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.postChain.setUniform("OutlineSize", (float)mc.getWindow().getGuiScale());
            this.postChain.process(delta);
            mc.getMainRenderTarget().bindWrite(false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            this.renderOutput.blitToScreen(mc.getWindow().getWidth(), mc.getWindow().getHeight(), false);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            mc.getMainRenderTarget().bindWrite(false);
        }
    }

    private record WrappedMultiBufferSource(MultiBufferSource delegate, int red, int green, int blue) implements MultiBufferSource
    {
        private WrappedMultiBufferSource(MultiBufferSource parent, int color) {
            this(parent, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
        }

        public VertexConsumer getBuffer(RenderType renderType) {
            return new WrappedVertexConsumer(this.delegate.getBuffer((RenderType)new WrappedRenderType(renderType)), this.red, this.green, this.blue);
        }
    }

    private record WrappedVertexConsumer(VertexConsumer delegate, int red, int green, int blue) implements VertexConsumer
    {
        public VertexConsumer addVertex(float f, float g, float h) {
            this.delegate.addVertex(f, g, h);
            return this;
        }

        public VertexConsumer setColor(int i, int j, int k, int l) {
            this.delegate.setColor(this.red, this.green, this.blue, 255);
            return this;
        }

        public VertexConsumer setUv(float f, float g) {
            this.delegate.setUv(f, g);
            return this;
        }

        public VertexConsumer setUv1(int i, int j) {
            this.delegate.setUv1(i, j);
            return this;
        }

        public VertexConsumer setUv2(int i, int j) {
            this.delegate.setUv2(i, j);
            return this;
        }

        public VertexConsumer setNormal(float f, float g, float h) {
            this.delegate.setNormal(f, g, h);
            return this;
        }
    }

    private static final class WrappedRenderType
    extends RenderType {
        public final RenderType delegate;

        public WrappedRenderType(RenderType delegate) {
            super("kubejs:wrapped", delegate.format(), delegate.mode(), delegate.bufferSize(), delegate.affectsCrumbling(), delegate.sortOnUpload(), () -> {
                delegate.setupRenderState();
                RenderSystem.setShader(() -> HighlightRenderer.INSTANCE.highlightShader);
            }, () -> ((RenderType)delegate).clearRenderState());
            this.delegate = delegate;
        }

        public String toString() {
            return "kubejs:wrapped[" + String.valueOf(this.delegate) + "]";
        }
    }
}

