/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.color;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.codec.KubeJSCodecs;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ColorWrapper;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.RemapForJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import dev.latvian.mods.rhino.util.SpecialEquality;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

@RemapPrefixForJS(value="kjs$")
public interface KubeColor
extends SpecialEquality {
    public static final Codec<KubeColor> CODEC = KubeJSCodecs.stringResolverCodec(KubeColor::kjs$serialize, ColorWrapper::wrap);
    public static final StreamCodec<ByteBuf, KubeColor> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    public static final StreamCodec<ByteBuf, Optional<KubeColor>> OPTIONAL_STREAM_CODEC = ByteBufCodecs.optional(STREAM_CODEC);

    @RemapForJS(value="getArgb")
    public int kjs$getARGB();

    @RemapForJS(value="getRgb")
    default public int kjs$getRGB() {
        return this.kjs$getARGB() & 0xFFFFFF;
    }

    default public int kjs$getFireworkRGB() {
        return this.kjs$getRGB();
    }

    default public String kjs$toHexString() {
        return String.format("#%08X", this.kjs$getARGB());
    }

    default public String kjs$serialize() {
        return this.kjs$toHexString();
    }

    default public TextColor kjs$createTextColor() {
        return TextColor.fromRgb((int)this.kjs$getRGB());
    }

    default public boolean specialEquals(Context cx, Object o, boolean shallow) {
        KubeColor c = ColorWrapper.wrap(o);
        return shallow ? this.kjs$getARGB() == c.kjs$getARGB() : this.kjs$getRGB() == c.kjs$getRGB();
    }
}

