/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.google.common.base.Strings;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.command.KubeJSCommands;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventGroups;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Scriptable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FileUtils;

public class DumpCommands {
    private static final char UNICODE_TICK = '\u2714';
    private static final char UNICODE_CROSS = '\u2718';

    public static int events(CommandSourceStack source) {
        Map<String, EventGroup> groups = EventGroups.ALL.get().map();
        Path output = KubeJSPaths.LOCAL.resolve("event_groups");
        for (Map.Entry<String, EventGroup> entry : groups.entrySet()) {
            String groupName = entry.getKey();
            EventGroup group = entry.getValue();
            Path groupFolder = output.resolve(groupName);
            try {
                Files.createDirectories(groupFolder, new FileAttribute[0]);
                FileUtils.cleanDirectory((File)groupFolder.toFile());
            }
            catch (IOException e) {
                ConsoleJS.SERVER.error("Failed to create folder for event group " + groupName, e);
                source.sendFailure((Component)Component.literal((String)("Failed to create folder for event group " + groupName)));
                return 0;
            }
            for (Map.Entry<String, EventHandler> handlerEntry : group.getHandlers().entrySet()) {
                String handlerName = handlerEntry.getKey();
                EventHandler handler = handlerEntry.getValue();
                Path handlerFile = groupFolder.resolve(handlerName + ".md");
                String fullName = "%s.%s".formatted(groupName, handlerName);
                Class<? extends KubeEvent> eventType = handler.eventType.get();
                StringBuilder builder = new StringBuilder();
                builder.append("# ").append(fullName).append("\n\n");
                builder.append("## Basic info\n\n");
                builder.append("- Valid script types: ").append(handler.scriptTypePredicate.getValidTypes()).append("\n\n");
                builder.append("- Has result? ").append(handler.getResult() != null ? (char)'\u2714' : '\u2718').append("\n\n");
                builder.append("- Event class: ");
                if (eventType.getPackageName().startsWith("dev.latvian.mods.kubejs")) {
                    builder.append('[').append(UtilsJS.toMappedTypeString(eventType)).append(']').append('(').append("https://github.com/KubeJS-Mods/KubeJS/tree/main/src/main/java/").append(eventType.getPackageName().replace('.', '/')).append('/').append(eventType.getSimpleName()).append(".java").append(')');
                } else {
                    builder.append(UtilsJS.toMappedTypeString(eventType)).append(" (third-party)");
                }
                builder.append("\n\n");
                Info classInfo = eventType.getAnnotation(Info.class);
                if (classInfo != null) {
                    builder.append("```\n").append(classInfo.value()).append("```");
                    builder.append("\n\n");
                }
                ServerScriptManager scriptManager = source.getServer().getServerResources().managers().kjs$getServerScriptManager();
                KubeJSContext cx = (KubeJSContext)scriptManager.contextFactory.enter();
                JavaMembers members = JavaMembers.lookupClass((Context)cx, (Scriptable)cx.topLevelScope, eventType, null, (boolean)false);
                boolean hasDocumentedMembers = false;
                StringBuilder documentedMembers = new StringBuilder("### Documented members:\n\n");
                builder.append("### Available fields:\n\n");
                builder.append("| Name | Type | Static? |\n");
                builder.append("| ---- | ---- | ------- |\n");
                for (JavaMembers.FieldInfo field : members.getAccessibleFields((Context)cx, false)) {
                    if (field.field.getDeclaringClass() == Object.class) continue;
                    String typeName = UtilsJS.toMappedTypeString(field.field.getGenericType());
                    builder.append("| ").append(field.name).append(" | ").append(typeName).append(" | ");
                    builder.append(Modifier.isStatic(field.field.getModifiers()) ? (char)'\u2714' : '\u2718').append(" |\n");
                    Info info = field.field.getAnnotation(Info.class);
                    if (info == null) continue;
                    hasDocumentedMembers = true;
                    documentedMembers.append("- `").append(typeName).append(' ').append(field.name).append("`\n");
                    documentedMembers.append("```\n");
                    String desc = info.value();
                    documentedMembers.append(desc);
                    if (!desc.endsWith("\n")) {
                        documentedMembers.append("\n");
                    }
                    documentedMembers.append("```\n\n");
                }
                builder.append("\n").append("Note: Even if no fields are listed above, some methods are still available as fields through *beans*.\n\n");
                builder.append("### Available methods:\n\n");
                builder.append("| Name | Parameters | Return type | Static? |\n");
                builder.append("| ---- | ---------- | ----------- | ------- |\n");
                for (JavaMembers.MethodInfo method : members.getAccessibleMethods((Context)cx, false)) {
                    int i;
                    if (method.hidden || method.method.getDeclaringClass() == Object.class) continue;
                    builder.append("| ").append(method.name).append(" | ");
                    Type[] params = method.method.getGenericParameterTypes();
                    CharSequence[] paramTypes = new String[params.length];
                    for (int i2 = 0; i2 < params.length; ++i2) {
                        paramTypes[i2] = UtilsJS.toMappedTypeString(params[i2]);
                    }
                    builder.append(String.join((CharSequence)", ", paramTypes)).append(" | ");
                    String returnType = UtilsJS.toMappedTypeString(method.method.getGenericReturnType());
                    builder.append(" | ").append(returnType).append(" | ");
                    builder.append(Modifier.isStatic(method.method.getModifiers()) ? (char)'\u2714' : '\u2718').append(" |\n");
                    Info info = method.method.getAnnotation(Info.class);
                    if (info == null) continue;
                    hasDocumentedMembers = true;
                    documentedMembers.append("- ").append('`');
                    if (Modifier.isStatic(method.method.getModifiers())) {
                        documentedMembers.append("static ");
                    }
                    documentedMembers.append(returnType).append(' ').append(method.name).append('(');
                    Param[] namedParams = info.params();
                    String[] paramNames = new String[params.length];
                    CharSequence[] signature = new String[params.length];
                    for (i = 0; i < params.length; ++i) {
                        String name1;
                        Object name = "var" + i;
                        if (namedParams.length > i && !Strings.isNullOrEmpty((String)(name1 = namedParams[i].name()))) {
                            name = name1;
                        }
                        paramNames[i] = name;
                        signature[i] = (String)paramTypes[i] + " " + (String)name;
                    }
                    documentedMembers.append(String.join((CharSequence)", ", signature)).append(')').append('`').append("\n");
                    if (params.length > 0) {
                        documentedMembers.append("\n  Parameters:\n");
                        for (i = 0; i < params.length; ++i) {
                            documentedMembers.append("  - ").append(paramNames[i]).append(": ").append((String)paramTypes[i]).append((String)(namedParams.length > i ? "- " + namedParams[i].value() : "")).append("\n");
                        }
                        documentedMembers.append("\n");
                    }
                    documentedMembers.append("```\n");
                    String desc = info.value();
                    documentedMembers.append(desc);
                    if (!desc.endsWith("\n")) {
                        documentedMembers.append("\n");
                    }
                    documentedMembers.append("```\n\n");
                }
                builder.append("\n\n");
                if (hasDocumentedMembers) {
                    builder.append((CharSequence)documentedMembers).append("\n\n");
                }
                builder.append("### Example script:\n\n");
                builder.append("```js\n");
                builder.append(fullName).append('(');
                if (handler.target != null) {
                    builder.append(handler.targetRequired ? "extra_id, " : "/* extra_id (optional), */ ");
                }
                builder.append("(event) => {\n");
                builder.append("\t// This space (un)intentionally left blank\n");
                builder.append("});\n");
                builder.append("```\n\n");
                try {
                    Files.writeString(handlerFile, (CharSequence)builder.toString(), new OpenOption[0]);
                }
                catch (IOException e) {
                    ConsoleJS.SERVER.error("Failed to write file for event handler " + fullName, e);
                    source.sendFailure((Component)Component.literal((String)("Failed to write file for event handler " + fullName)));
                    return 0;
                }
            }
        }
        source.sendSystemMessage((Component)Component.literal((String)("Successfully dumped event groups to " + String.valueOf(output))));
        return 1;
    }

    public static <T> int registry(CommandSourceStack source, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        Stream ids = ((Registry)source.registryAccess().registry(registry).orElseThrow(() -> KubeJSCommands.NO_REGISTRY.create((Object)registry.location()))).holders();
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)("List of all entries for registry " + String.valueOf(registry.location()) + ":")));
        source.sendSystemMessage((Component)Component.empty());
        long size = ids.map(holder -> {
            ResourceLocation id = holder.key().location();
            return Component.literal((String)"- %s".formatted(id)).withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"%s [%s]".formatted(holder.value(), holder.value().getClass().getName())))));
        }).mapToLong(msg -> {
            source.sendSystemMessage((Component)msg);
            return 1L;
        }).sum();
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)"Total: %d entries".formatted(size)));
        source.sendSystemMessage((Component)Component.empty());
        return 1;
    }
}

