/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.ingredient.NamespaceIngredient;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class InformationCommands {
    private static Component copy(String s, ChatFormatting col, String info) {
        return InformationCommands.copy((Component)Component.literal((String)s).withStyle(col), (Component)Component.literal((String)info));
    }

    private static Component copy(String s, ChatFormatting col, Component info) {
        return InformationCommands.copy((Component)Component.literal((String)s).withStyle(col), info);
    }

    private static Component copy(Component c, Component info) {
        return Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, c.getString()))).withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)info.copy().append(" (Click to copy)")))).append(c);
    }

    public static int hand(ServerPlayer player, InteractionHand hand) {
        Optional containedFluid;
        Integer size;
        String id;
        Item tab2;
        String id2;
        player.sendSystemMessage((Component)Component.literal((String)"Item in hand:"));
        ItemStack stack = player.getItemInHand(hand);
        Holder holder = stack.getItemHolder();
        Registry itemRegistry = (Registry)player.server.registryAccess().registry(Registries.ITEM).orElseThrow();
        Registry blockRegistry = (Registry)player.server.registryAccess().registry(Registries.BLOCK).orElseThrow();
        Registry fluidRegistry = (Registry)player.server.registryAccess().registry(Registries.FLUID).orElseThrow();
        Registry tabRegistry = (Registry)player.server.registryAccess().registry(Registries.CREATIVE_MODE_TAB).orElseThrow();
        player.sendSystemMessage(InformationCommands.copy(stack.kjs$toItemString0((DynamicOps)player.server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE)), ChatFormatting.GREEN, "Item ID"));
        List itemTags = holder.tags().toList();
        for (TagKey tag : itemTags) {
            id2 = "'#%s'".formatted(tag.location());
            Integer size2 = itemRegistry.getTag(tag).map(HolderSet::size).orElse(0);
            player.sendSystemMessage(InformationCommands.copy(id2, ChatFormatting.YELLOW, "Item Tag [" + size2 + " items]"));
        }
        player.sendSystemMessage(InformationCommands.copy("'@" + stack.kjs$getMod() + "'", ChatFormatting.AQUA, "Mod [" + new NamespaceIngredient(stack.kjs$getMod()).toVanilla().kjs$getStacks().size() + " items]"));
        for (Item tab2 : tabRegistry) {
            if (!tab2.contains(stack)) continue;
            id2 = tabRegistry.getKey((Object)tab2);
            int count = tab2.getDisplayItems().size();
            int searchCount = tab2.getSearchTabDisplayItems().size();
            player.sendSystemMessage(InformationCommands.copy("'%" + String.valueOf(id2) + "'", ChatFormatting.LIGHT_PURPLE, (Component)tab2.getDisplayName().copy().append(" [%d/%d items in tab / search tab]".formatted(count, searchCount))));
        }
        tab2 = stack.getItem();
        if (tab2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)tab2;
            player.sendSystemMessage((Component)Component.literal((String)"Held block:"));
            Block block = blockItem.getBlock();
            Holder.Reference blockHolder = block.builtInRegistryHolder();
            player.sendSystemMessage(InformationCommands.copy("'" + block.kjs$getId() + "'", ChatFormatting.GREEN, "Block ID"));
            List blockTags = blockHolder.tags().toList();
            for (TagKey tag : blockTags) {
                id = "'#%s'".formatted(tag.location());
                size = blockRegistry.getTag(tag).map(HolderSet::size).orElse(0);
                player.sendSystemMessage(InformationCommands.copy(id, ChatFormatting.YELLOW, "Block Tag [" + size + " items]"));
            }
        }
        if ((containedFluid = FluidUtil.getFluidContained((ItemStack)stack)).isPresent()) {
            player.sendSystemMessage((Component)Component.literal((String)"Held fluid:"));
            FluidStack fluid = (FluidStack)containedFluid.orElseThrow();
            Holder.Reference fluidHolder = fluid.getFluid().builtInRegistryHolder();
            player.sendSystemMessage(InformationCommands.copy(fluidHolder.key().location().toString(), ChatFormatting.GREEN, "Fluid ID"));
            List fluidTags = fluidHolder.tags().toList();
            for (TagKey tag : fluidTags) {
                id = "'#%s'".formatted(tag.location());
                size = fluidRegistry.getTag(tag).map(HolderSet::size).orElse(0);
                player.sendSystemMessage(InformationCommands.copy(id, ChatFormatting.YELLOW, "Fluid Tag [" + size + " items]"));
            }
        }
        return 1;
    }

    public static int inventory(ServerPlayer player) {
        return InformationCommands.dump((List<ItemStack>)player.getInventory().items, player, "Inventory");
    }

    public static int hotbar(ServerPlayer player) {
        return InformationCommands.dump(player.getInventory().items.subList(0, 9), player, "Hotbar");
    }

    public static int dump(List<ItemStack> stacks, ServerPlayer player, String name) {
        RegistryOps ops = player.server.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        List<String> dump = stacks.stream().filter(is -> !is.isEmpty()).map(is -> is.kjs$toItemString0((DynamicOps)ops)).toList();
        player.sendSystemMessage(InformationCommands.copy(dump.toString(), ChatFormatting.WHITE, name + " Item List"));
        return 1;
    }
}

