/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.core.DataSenderKJS;
import dev.latvian.mods.kubejs.core.EntityCollectionKJS;
import dev.latvian.mods.kubejs.core.MinecraftEnvironmentKJS;
import dev.latvian.mods.kubejs.core.NoMixinException;
import dev.latvian.mods.kubejs.core.PlayerSelector;
import dev.latvian.mods.kubejs.core.WithAttachedData;
import dev.latvian.mods.kubejs.core.WithPersistentData;
import dev.latvian.mods.kubejs.net.KubeJSNet;
import dev.latvian.mods.kubejs.net.SendDataFromServerPayload;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.server.ChangesForChat;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface MinecraftServerKJS
extends WithAttachedData<MinecraftServer>,
WithPersistentData,
DataSenderKJS,
MinecraftEnvironmentKJS,
EntityCollectionKJS {
    default public MinecraftServer kjs$self() {
        return (MinecraftServer)this;
    }

    public ServerLevel kjs$getOverworld();

    @Override
    default public Component kjs$getName() {
        return Component.literal((String)this.kjs$self().name());
    }

    @Override
    default public void kjs$tell(Component message) {
        this.kjs$self().sendSystemMessage(message);
        for (ServerPlayer player : this.kjs$self().getPlayerList().getPlayers()) {
            player.kjs$tell(message);
        }
    }

    @Override
    default public void kjs$setStatusMessage(Component message) {
        for (ServerPlayer player : this.kjs$self().getPlayerList().getPlayers()) {
            player.kjs$setStatusMessage(message);
        }
    }

    @Override
    default public void kjs$runCommand(String command) {
        this.kjs$self().getCommands().performPrefixedCommand(this.kjs$self().createCommandSourceStack(), command);
    }

    @Override
    default public void kjs$runCommandSilent(String command) {
        this.kjs$self().getCommands().performPrefixedCommand(this.kjs$self().createCommandSourceStack().withSuppressedOutput(), command);
    }

    @Override
    default public void kjs$setActivePostShader(@Nullable ResourceLocation id) {
        for (ServerPlayer player : this.kjs$self().getPlayerList().getPlayers()) {
            player.kjs$setActivePostShader(id);
        }
    }

    default public ServerLevel kjs$getLevel(ResourceLocation dimension) {
        return this.kjs$self().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension));
    }

    @Nullable
    default public ServerPlayer kjs$getPlayer(PlayerSelector selector) {
        return selector.getPlayer(this.kjs$self());
    }

    @Override
    default public Iterable<? extends Entity> kjs$getMcEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>(10);
        for (ServerLevel level : this.kjs$self().getAllLevels()) {
            Iterable i = level.getAllEntities();
            if (i instanceof Collection) {
                Collection c = (Collection)i;
                list.addAll(c);
                continue;
            }
            for (Entity e : i) {
                list.add(e);
            }
        }
        return list;
    }

    @Override
    default public List<? extends Player> kjs$getMcPlayers() {
        return this.kjs$self().getPlayerList().getPlayers();
    }

    @Override
    default public EntityArrayList kjs$getPlayers() {
        return new EntityArrayList(this.kjs$self().getPlayerList().getPlayers());
    }

    @Override
    @Nullable
    default public Entity kjs$getEntityByUUID(UUID id) {
        for (ServerLevel level : this.kjs$self().getAllLevels()) {
            Entity e = (Entity)level.getEntities().get(id);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    @Nullable
    default public Entity kjs$getEntityByNetworkID(int id) {
        for (ServerLevel level : this.kjs$self().getAllLevels()) {
            Entity e = (Entity)level.getEntities().get(id);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Nullable
    default public AdvancementNode kjs$getAdvancement(ResourceLocation id) {
        return this.kjs$self().getAdvancements().tree().get(id);
    }

    @Override
    default public void kjs$sendData(String channel, @Nullable CompoundTag data) {
        KubeJSNet.sendToAllPlayers(new SendDataFromServerPayload(channel, data), new CustomPacketPayload[0]);
    }

    @HideFromJS
    default public void kjs$afterResourcesLoaded(boolean reload) {
        if (reload) {
            DataExport.exportData();
        }
        ConsoleJS.SERVER.stopCapturingErrors();
        if (reload && CommonProperties.get().announceReload && !CommonProperties.get().hideServerScriptErrors) {
            if (ConsoleJS.SERVER.errors.isEmpty()) {
                this.kjs$tell((Component)Component.literal((String)"Reloaded with no KubeJS errors!").withStyle(ChatFormatting.GREEN));
            } else {
                this.kjs$tell(ConsoleJS.SERVER.errorsComponent("/kubejs errors server"));
            }
            if (DevProperties.get().logChangesInChat) {
                ChangesForChat.print(this::kjs$tell);
            }
        }
        ConsoleJS.SERVER.info("Server resource reload complete!");
    }

    default public Map<UUID, Map<Integer, ItemStack>> kjs$restoreInventories() {
        throw new NoMixinException();
    }
}

