/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import dev.latvian.mods.kubejs.plugin.builtin.wrapper.UUIDWrapper;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface PlayerSelector {
    public static PlayerSelector wrap(Object o) {
        if (o instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)o;
            return PlayerSelector.identity(sp);
        }
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            return PlayerSelector.uuid(uuid);
        }
        String name = Objects.toString(o, "").trim().toLowerCase(Locale.ROOT);
        if (name.isEmpty()) {
            return PlayerSelector.identity(null);
        }
        UUID uuid = UUIDWrapper.fromString(name);
        if (uuid != null) {
            return PlayerSelector.uuid(uuid);
        }
        return PlayerSelector.name(name).or(PlayerSelector.fuzzyName(name));
    }

    @Nullable
    public ServerPlayer getPlayer(MinecraftServer var1);

    public static PlayerSelector identity(ServerPlayer player) {
        return server -> player;
    }

    public static PlayerSelector uuid(UUID uuid) {
        return server -> server.getPlayerList().getPlayer(uuid);
    }

    public static PlayerSelector name(String name) {
        return server -> server.getPlayerList().getPlayerByName(name);
    }

    public static PlayerSelector fuzzyName(String name) {
        return server -> {
            for (ServerPlayer p : server.getPlayerList().getPlayers()) {
                if (!p.getScoreboardName().toLowerCase(Locale.ROOT).contains(name)) continue;
                return p;
            }
            return null;
        };
    }

    default public PlayerSelector or(PlayerSelector fallback) {
        return server -> {
            ServerPlayer p = this.getPlayer(server);
            return p == null ? fallback.getPlayer(server) : p;
        };
    }
}

