/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeTypeRegistryContext;
import dev.latvian.mods.kubejs.recipe.schema.RecipeOptional;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaData;
import dev.latvian.mods.kubejs.recipe.schema.function.RecipeSchemaFunction;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessor;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class RecipeSchemaProvider
implements DataProvider {
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final String name;
    private final RegistryAccessContainer registryAccessContainer;
    private final PackOutput.PathProvider path;
    private final ImmutableMap.Builder<ResourceLocation, RecipeSchemaData> map;
    private final ServerScriptManager scriptManager;
    private final RecipeTypeRegistryContext regCtx;
    private final Codec<RecipeSchemaData> codec;

    public RecipeSchemaProvider(String name, GatherDataEvent event) {
        this(name, event, RegistryAccessContainer.BUILTIN);
    }

    public RecipeSchemaProvider(String name, GatherDataEvent event, RegistryAccessContainer registryAccessContainer) {
        this.lookupProvider = event.getLookupProvider();
        this.name = name;
        this.registryAccessContainer = registryAccessContainer;
        this.path = event.getGenerator().getPackOutput().createPathProvider(PackOutput.Target.DATA_PACK, "kubejs/recipe_schema");
        this.map = ImmutableMap.builder();
        this.scriptManager = ServerScriptManager.createForDataGen();
        this.regCtx = new RecipeTypeRegistryContext(registryAccessContainer, this.scriptManager.recipeSchemaStorage);
        this.scriptManager.recipeSchemaStorage.fireEvents(registryAccessContainer, event.getResourceManager(PackType.SERVER_DATA));
        this.codec = RecipeSchemaData.CODEC.apply(this.regCtx);
    }

    public final RegistryAccessContainer registryAccessContainer() {
        return this.registryAccessContainer;
    }

    public final ServerScriptManager serverScriptManager() {
        return this.scriptManager;
    }

    public final RecipeTypeRegistryContext recipeTypeRegistryContext() {
        return this.regCtx;
    }

    public abstract void add(HolderLookup.Provider var1);

    public void add(ResourceLocation id, RecipeSchemaData schema) {
        this.map.put((Object)id, (Object)schema);
    }

    public void add(ResourceLocation id, Consumer<SchemaDataBuilder> builder) {
        this.add(id, ((SchemaDataBuilder)Util.make((Object)new SchemaDataBuilder(), builder)).build());
    }

    public void onlyKeys(ResourceLocation id, RecipeKey<?> ... keys) {
        this.add(id, (SchemaDataBuilder b) -> b.keys(keys));
    }

    public RecipeSchemaData.RecipeKeyData keyData(RecipeKey<?> key) {
        if (key.functionNames == null) {
            key.noFunctions();
        }
        return new RecipeSchemaData.RecipeKeyData(key.name, key.role, key.component, Optional.ofNullable(key.optional).map(RecipeOptional::getInformativeValue).map(value -> (JsonElement)key.codec.encodeStart(this.registryAccessContainer.json(), Cast.to(value)).getOrThrow()), key.optional == RecipeOptional.DEFAULT, new ArrayList<String>(key.names), key.excluded, key.functionNames, key.alwaysWrite);
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return this.lookupProvider.thenCompose(p -> {
            this.add((HolderLookup.Provider)p);
            return CompletableFuture.allOf((CompletableFuture[])this.map.buildOrThrow().entrySet().stream().map(e -> DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)p, this.codec, (Object)((RecipeSchemaData)e.getValue()), (Path)this.path.json((ResourceLocation)e.getKey()))).toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return this.name;
    }

    public class SchemaDataBuilder {
        private ResourceLocation parent;
        private ResourceLocation overrideType;
        private ResourceLocation recipeFactory;
        private List<RecipeSchemaData.RecipeKeyData> keys;
        private List<RecipeSchemaData.ConstructorData> constructors;
        private Map<String, RecipeSchemaFunction> functions;
        private final Map<String, JsonElement> overrideKeys = new HashMap<String, JsonElement>();
        boolean hidden = false;
        private final List<String> mappings = new ArrayList<String>();
        private List<String> unique;
        private List<RecipePostProcessor> postProcessors;
        private RecipeSchemaData.MergeData mergeData = RecipeSchemaData.MergeData.DEFAULT;

        public SchemaDataBuilder parent(ResourceLocation parent) {
            this.parent = parent;
            return this;
        }

        public SchemaDataBuilder overrideType(ResourceLocation type) {
            this.overrideType = type;
            return this;
        }

        public SchemaDataBuilder recipeFactory(ResourceLocation factory) {
            this.recipeFactory = factory;
            return this;
        }

        public SchemaDataBuilder keys(RecipeKey<?> ... keys) {
            return this.keys(List.of(keys));
        }

        public SchemaDataBuilder keys(List<RecipeKey<?>> keys) {
            return this.keyDatas(keys.stream().map(RecipeSchemaProvider.this::keyData).toList());
        }

        public SchemaDataBuilder keyDatas(RecipeSchemaData.RecipeKeyData ... keys) {
            return this.keyDatas(List.of(keys));
        }

        public SchemaDataBuilder keyDatas(List<RecipeSchemaData.RecipeKeyData> keys) {
            if (this.keys == null) {
                this.keys = new ArrayList<RecipeSchemaData.RecipeKeyData>(keys);
            } else {
                this.keys.addAll(keys);
            }
            return this;
        }

        public SchemaDataBuilder constructors(RecipeSchemaData.ConstructorData ... constructors) {
            return this.constructors(List.of(constructors));
        }

        public SchemaDataBuilder constructors(List<RecipeSchemaData.ConstructorData> constructors) {
            if (this.constructors == null) {
                this.constructors = new ArrayList<RecipeSchemaData.ConstructorData>(constructors);
            } else {
                this.constructors.addAll(constructors);
            }
            return this;
        }

        public SchemaDataBuilder function(String name, RecipeSchemaFunction function) {
            return this.functions(Map.of(name, function));
        }

        public SchemaDataBuilder functions(Map<String, RecipeSchemaFunction> functions) {
            if (this.functions == null) {
                this.functions = new HashMap<String, RecipeSchemaFunction>(functions);
            } else {
                this.functions.putAll(functions);
            }
            return this;
        }

        public <T> SchemaDataBuilder overrideKey(RecipeKey<T> key, @Nullable T optionalValue) {
            JsonElement encoded = optionalValue != null ? (JsonElement)key.codec.encodeStart(RecipeSchemaProvider.this.registryAccessContainer.json(), optionalValue).getOrThrow() : null;
            this.overrideKeys.put(key.name, encoded);
            return this;
        }

        public SchemaDataBuilder hidden() {
            return this.hidden(true);
        }

        public SchemaDataBuilder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public SchemaDataBuilder mappings(String ... mappings) {
            return this.mappings(List.of(mappings));
        }

        public SchemaDataBuilder mappings(List<String> mappings) {
            this.mappings.addAll(mappings);
            return this;
        }

        public SchemaDataBuilder keysForUniqueId(String ... keys) {
            return this.keysForUniqueId(List.of(keys));
        }

        public SchemaDataBuilder keysForUniqueId(List<String> keys) {
            if (this.unique == null) {
                this.unique = new ArrayList<String>(keys);
            } else {
                this.unique.addAll(keys);
            }
            return this;
        }

        public SchemaDataBuilder postProcessors(RecipePostProcessor ... processors) {
            return this.postProcessors(List.of(processors));
        }

        public SchemaDataBuilder postProcessors(List<RecipePostProcessor> processors) {
            if (this.postProcessors == null) {
                this.postProcessors = new ArrayList<RecipePostProcessor>(processors);
            } else {
                this.postProcessors.addAll(processors);
            }
            return this;
        }

        public SchemaDataBuilder mergeData(boolean keys, boolean constructors, boolean unique, boolean postProcessors) {
            this.mergeData = new RecipeSchemaData.MergeData(keys, constructors, unique, postProcessors);
            return this;
        }

        RecipeSchemaData build() {
            return new RecipeSchemaData(this.parent, this.overrideType, this.recipeFactory, this.keys, this.constructors, this.functions, this.overrideKeys, this.hidden, this.mappings, this.unique, this.postProcessors, this.mergeData);
        }
    }
}

