/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.util.TickTemporalUnit;
import dev.latvian.mods.kubejs.util.TimeJS;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;

public record TickDuration(long ticks) implements TemporalAmount
{
    public static final TickDuration ZERO = new TickDuration(0L);
    private static final List<TemporalUnit> UNITS = List.of(TickTemporalUnit.INSTANCE);
    public static final Codec<TickDuration> CODEC = Codec.LONG.xmap(TickDuration::of, TickDuration::ticks);
    public static final Codec<TickDuration> SECONDS_CODEC = Codec.DOUBLE.xmap(l -> TickDuration.of((long)(l * 20.0)), t -> (double)t.ticks() / 20.0);
    public static final Codec<TickDuration> MINUTES_CODEC = Codec.DOUBLE.xmap(l -> TickDuration.of((long)(l * 1200.0)), t -> (double)t.ticks() / 1200.0);
    public static final Codec<TickDuration> HOURS_CODEC = Codec.DOUBLE.xmap(l -> TickDuration.of((long)(l * 72000.0)), t -> (double)t.ticks() / 72000.0);
    public static final TypeInfo TYPE_INFO = TypeInfo.of(TickDuration.class);

    public static TickDuration of(long ticks) {
        return ticks == 0L ? ZERO : new TickDuration(ticks);
    }

    public static TickDuration wrap(Object from) {
        Object object = from;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TickDuration.class, Number.class, JsonPrimitive.class}, (Object)object, n)) {
            case -1 -> ZERO;
            case 0 -> {
                TickDuration d;
                yield d = (TickDuration)object;
            }
            case 1 -> {
                Number n = (Number)object;
                yield TickDuration.of(n.longValue());
            }
            case 2 -> {
                JsonPrimitive json = (JsonPrimitive)object;
                yield TickDuration.of(json.getAsLong());
            }
            default -> TickDuration.of(TimeJS.wrapDuration(from).toMillis() / 50L);
        };
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == TickTemporalUnit.INSTANCE) {
            return this.ticks;
        }
        return 0L;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return UNITS;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.ticks != 0L) {
            return temporal.plus(this.ticks, TickTemporalUnit.INSTANCE);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.ticks != 0L) {
            return temporal.minus(this.ticks, TickTemporalUnit.INSTANCE);
        }
        return temporal;
    }

    @Override
    public String toString() {
        return this.ticks + " ticks";
    }

    public int intTicks() {
        return Math.clamp(this.ticks, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }
}

