/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.SignText;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.registry.BnCEffects;

public class BnCClientTextUtils {
    public static final ResourceKey<ChatType> STYLED_CHAT_HACK_CHAT_TYPE = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"styled_chat", (String)"generic_hack"));
    public static int tipsyMessageLevel = 0;
    public static boolean generatedRandom = false;
    public static int clearDelayAmount = 0;
    public static long randomSeed = 0L;
    private static PlayerChatMessage nextTipsyMessage;

    public static Component modifyComponents(Component original, long randomSeed) {
        StringBuilder textBuilder = new StringBuilder(original.getContents().visit(Optional::ofNullable).orElse(""));
        if (!textBuilder.isEmpty()) {
            List globalWords;
            List validWords;
            int amplifier = tipsyMessageLevel;
            if (Minecraft.getInstance().player.hasEffect(BnCEffects.TIPSY) && amplifier < Minecraft.getInstance().player.getEffect(BnCEffects.TIPSY).getAmplifier()) {
                amplifier = Minecraft.getInstance().player.getEffect(BnCEffects.TIPSY).getAmplifier();
            }
            RandomSource random = RandomSource.create((long)randomSeed);
            int amnt = (int)((float)((amplifier -= ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).root().levelChatScramble()) + 1) * ((float)textBuilder.length() / 6.0f)) + random.nextInt(amplifier, amplifier + 2) - 1;
            for (int i = 0; i < amnt && !(validWords = (List)(globalWords = (List)Arrays.stream(textBuilder.toString().split(" ")).collect(Collectors.toCollection(ArrayList::new))).stream().filter(s -> s.length() > 3).collect(Collectors.toCollection(ArrayList::new))).isEmpty(); ++i) {
                int wordIndex = random.nextInt(validWords.size());
                String word = (String)validWords.get(wordIndex);
                int globalWordLength = globalWords.subList(0, globalWords.indexOf(word)).stream().mapToInt(value -> value.length() + 1).sum();
                int index = globalWordLength + random.nextInt(1, word.length() - 2);
                int newIndex = Mth.clamp((int)(index + (random.nextBoolean() ? 1 : -1)), (int)(globalWordLength + 1), (int)(globalWordLength + word.length() - 2));
                char temp = textBuilder.charAt(index);
                textBuilder.setCharAt(index, textBuilder.charAt(newIndex));
                textBuilder.setCharAt(newIndex, temp);
            }
            String text = textBuilder.toString();
            MutableComponent component = Component.literal((String)text).withStyle(original.getStyle());
            for (Component sibling : original.getSiblings()) {
                component.append(BnCClientTextUtils.modifyComponents(sibling, randomSeed));
            }
            return component;
        }
        MutableComponent component = Component.empty();
        for (Component sibling : original.getSiblings()) {
            component.append(BnCClientTextUtils.modifyComponents(sibling, randomSeed));
        }
        return component;
    }

    public static void setupChatMessage(PlayerChatMessage chatMessage) {
        if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).scrambleChat() && (tipsyMessageLevel > 0 || Minecraft.getInstance().player.hasEffect(BnCEffects.TIPSY) && Minecraft.getInstance().player.getEffect(BnCEffects.TIPSY).getAmplifier() >= ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).root().levelChatScramble())) {
            if (!generatedRandom) {
                randomSeed = Minecraft.getInstance().player.getRandom().nextLong();
            }
            Component newMessage = BnCClientTextUtils.modifyComponents(chatMessage.decoratedContent(), randomSeed);
            if (!chatMessage.decoratedContent().equals((Object)newMessage)) {
                nextTipsyMessage = chatMessage.withUnsignedContent(newMessage);
            }
        }
    }

    public static PlayerChatMessage getTipsyMessage() {
        return nextTipsyMessage;
    }

    public static void clearTipsyMessage() {
        nextTipsyMessage = null;
    }

    public static MutableComponent getStyledChatPrefix(ChatType.Bound bound, Component message) {
        TranslatableContents boundTranslatable;
        Object object;
        if (bound.chatType().is(STYLED_CHAT_HACK_CHAT_TYPE) && (object = message.getContents()) instanceof TranslatableContents && (object = (boundTranslatable = (TranslatableContents)object).getArgs()[0]) instanceof MutableComponent) {
            MutableComponent innerMutable = (MutableComponent)object;
            MutableComponent oldComponent = innerMutable.copy();
            ComponentContents componentContents = oldComponent.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatable = (TranslatableContents)componentContents;
                ArrayList<Object> args = new ArrayList<Object>(List.of(translatable.getArgs()));
                args.removeLast();
                args.add(Component.empty());
                return Component.translatable((String)translatable.getKey(), (Object[])args.toArray()).withStyle(oldComponent.getStyle());
            }
            return BnCClientTextUtils.handleSiblings(Component.empty(), (Component)innerMutable, true);
        }
        return message.copy();
    }

    private static MutableComponent handleSiblings(MutableComponent newMessage, Component oldComponent, boolean originalCall) {
        newMessage.append((Component)oldComponent.plainCopy().withStyle(oldComponent.getStyle()));
        if (oldComponent.getSiblings().isEmpty()) {
            return newMessage;
        }
        for (int i = 0; i < oldComponent.getSiblings().size(); ++i) {
            if (originalCall && i >= oldComponent.getSiblings().size() - 1) continue;
            BnCClientTextUtils.handleSiblings(newMessage, (Component)oldComponent.getSiblings().get(i), false);
        }
        return newMessage;
    }

    public static Component nameTagRenderer(Component original) {
        if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).scrambleName() && Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasEffect(BnCEffects.TIPSY) && Minecraft.getInstance().player.getEffect(BnCEffects.TIPSY).getAmplifier() >= ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).root().levelNameScramble()) {
            return BnCClientTextUtils.modifyComponents(original, 0L);
        }
        return original;
    }

    public static SignText signRenderer(SignText signText) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).scrambleSign() || player == null) {
            return signText;
        }
        int minScrambleAmplifier = ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).root().levelSignScramble();
        if (player.hasEffect(BnCEffects.TIPSY) && player.getEffect(BnCEffects.TIPSY).getAmplifier() >= minScrambleAmplifier) {
            for (int i = 0; i < 4; ++i) {
                signText = signText.setMessage(i, BnCClientTextUtils.modifyComponents(signText.getMessage(i, false), 0L));
            }
        }
        return signText;
    }
}

