/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import umpaz.brewinandchewin.common.registry.BnCItems;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class FieryFonduePotBlock
extends Block {
    public static final VoxelShape INSIDE = FieryFonduePotBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)FieryFonduePotBlock.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{FieryFonduePotBlock.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), FieryFonduePotBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL_CAULDRON;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public FieryFonduePotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(3))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected double getContentHeight(BlockState state) {
        return (6.0 + (double)((Integer)state.getValue((Property)LEVEL)).intValue() * 3.0) / 16.0;
    }

    public boolean isEntityInsideContent(BlockState state, BlockPos pos, Entity entity) {
        return entity.getY() < (double)pos.getY() + this.getContentHeight(state) && entity.getBoundingBox().maxY > (double)pos.getY() + 0.25;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.isEntityInsideContent(state, pos, entity)) {
            entity.lavaHurt();
        }
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)LEVEL);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{LEVEL, FACING});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.takeServing(level, pos, state, player, hand);
    }

    private ItemInteractionResult takeServing(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn) {
        int servings = (Integer)state.getValue((Property)LEVEL);
        ItemStack bowl = new ItemStack((ItemLike)Items.BOWL);
        ItemStack fondue = new ItemStack((ItemLike)BnCItems.FIERY_FONDUE);
        ItemStack heldStack = player.getItemInHand(handIn);
        if (heldStack.is(bowl.getItem())) {
            if (!player.getAbilities().instabuild) {
                heldStack.shrink(1);
            }
            if (!player.getInventory().add(fondue)) {
                player.drop(fondue, false);
            }
            BlockState newState = (Integer)level.getBlockState(pos).getValue((Property)LEVEL) > 1 ? (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(servings - 1)) : Blocks.CAULDRON.defaultBlockState();
            level.setBlock(pos, newState, 3);
            if ((Integer)state.getValue((Property)LEVEL) == 1) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)Items.BONE));
            }
            level.playSound(null, pos, (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.translatable((String)"farmersdelight.block.feast.use_container", (Object[])new Object[]{bowl.getHoverName()}), true);
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return INSIDE;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, BlockGetter level, BlockPos pos, PathComputationType path) {
        return false;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, level, pos, rand);
        RandomSource random = level.random;
        if (random.nextFloat() < 0.8f) {
            double x = (double)pos.getX() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
            double y = (double)pos.getY() + this.getContentHeight(stateIn);
            double z = (double)pos.getZ() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
            level.addParticle((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, 0.0, 0.0);
            double x1 = (double)pos.getX() + 0.5;
            double y1 = pos.getY();
            double z1 = (double)pos.getZ() + 0.5;
            if (rand.nextInt(10) == 0) {
                level.playLocalSound(x1, y1, z1, (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL_SOUP.get(), SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }
}

