/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.item.BoozeItem;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;

public class DreadNogItem
extends BoozeItem {
    public DreadNogItem(Supplier<Fluid> fluid, Item.Properties properties) {
        super(fluid, properties);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        if (!level.isClientSide) {
            Optional<FoodProperties.PossibleEffect> badOmen = BrewinAndChewin.getHelper().getFoodProperties(stack, consumer).effects().stream().filter(pair -> pair.effect().getEffect() == MobEffects.BAD_OMEN).findFirst();
            this.affectConsumerBadOmen(consumer, badOmen.map(pair -> pair.effect().getDuration()).orElse(0), badOmen.map(pair -> pair.effect().getAmplifier()).orElse(-1));
        }
        return super.finishUsingItem(stack, level, consumer);
    }

    public void affectConsumerBadOmen(LivingEntity consumer, int duration, int potency) {
        if (consumer.hasEffect(MobEffects.BAD_OMEN)) {
            MobEffectInstance effect = consumer.getEffect(MobEffects.BAD_OMEN);
            consumer.addEffect(new MobEffectInstance(MobEffects.BAD_OMEN, effect.getDuration() == -1 ? -1 : Math.max(effect.getDuration(), duration), Math.min(effect.getAmplifier() + potency + 1, 4), effect.isAmbient(), effect.isVisible(), effect.showIcon()));
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, ctx, tooltip, flagIn);
        for (int i = 0; i < tooltip.size(); ++i) {
            Component tt = tooltip.get(i);
            if (!tt.contains(((MobEffect)MobEffects.BAD_OMEN.value()).getDisplayName())) continue;
            tooltip.set(i, (Component)BnCTextUtils.getTranslation("tooltip.dread_nog", new Object[0]).withStyle(ChatFormatting.RED));
        }
    }
}

