/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.neoforge.client.platform;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.neoforge.client.model.CoasterWrappedModel;
import umpaz.brewinandchewin.platform.client.BnCClientPlatformHelper;

public class BnCClientPlatfomHelperNeoForge
implements BnCClientPlatformHelper {
    @Override
    public BakedModel getModel(ResourceLocation modelId) {
        return Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)modelId));
    }

    @Override
    public void tesselateCoasterModel(BlockAndTintGetter level, ResourceLocation modelId, BlockState state, BlockPos pos, PoseStack poseStack, MultiBufferSource buffer, RandomSource random, long seed, int packedOverlay, int tintIndex, RenderType renderType) {
        ModelData data = ModelData.EMPTY;
        if (tintIndex != -1) {
            data = ModelData.builder().with(CoasterWrappedModel.TINT_INDEX, (Object)tintIndex).build();
        }
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().tesselateBlock(level, Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)modelId)), state, pos, poseStack, buffer.getBuffer(renderType), false, random, seed, packedOverlay, data, renderType);
    }

    @Override
    public void renderFluidInKeg(AbstractedFluidStack stack, GuiGraphics gui, int x, int y, float alphaModifier) {
        int y2;
        int y1;
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)stack.fluid());
        FluidStack fluidStack = (FluidStack)stack.loaderSpecific();
        if (fluidStack == null) {
            return;
        }
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
        int tintColor = fluidTypeExtensions.getTintColor(fluidStack);
        float alpha = (float)(tintColor >> 24 & 0xFF) / 255.0f * alphaModifier;
        float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(tintColor & 0xFF) / 255.0f;
        float capacity = (float)Math.min(((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity(), stack.unit().convertToLoader(stack.amount())) / (float)((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity();
        if ((double)capacity > 0.57) {
            y1 = y + (int)(12.0f * (1.0f - (capacity - 0.57f) / 0.43f));
            y2 = y + 12;
            float topCapacity = (capacity - 0.57f) / 0.43f;
            float vDistance = sprite.getV1() - sprite.getV0();
            float v0 = sprite.getV0() + 0.25f * vDistance + 0.75f * vDistance * (1.0f - topCapacity);
            gui.innerBlit(sprite.atlasLocation(), x, x + 16, y1, y2, 0, sprite.getU0(), sprite.getU1(), v0, sprite.getV1(), red, green, blue, alpha);
            gui.innerBlit(sprite.atlasLocation(), x + 16, x + 16 + 8, y1, y2, 0, sprite.getU0(), sprite.getU0() + 0.5f * (sprite.getU1() - sprite.getU0()), v0, sprite.getV1(), red, green, blue, alpha);
        }
        y1 = y + 12 + (int)(16.0f * (1.0f - Math.min(1.0f, capacity / 0.57f)));
        y2 = y + 12 + 16;
        float vDistance = sprite.getV1() - sprite.getV0();
        float v0 = sprite.getV0() + vDistance * (1.0f - Math.min(1.0f, capacity / 0.57f));
        gui.innerBlit(sprite.atlasLocation(), x, x + 16, y1, y2, 0, sprite.getU0(), sprite.getU1(), v0, sprite.getV1(), red, green, blue, alpha);
        gui.innerBlit(sprite.atlasLocation(), x + 16, x + 16 + 8, y1, y2, 0, sprite.getU0(), sprite.getU0() + 0.5f * (sprite.getU1() - sprite.getU0()), v0, sprite.getV1(), red, green, blue, alpha);
    }
}

