/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.neoforge.container;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;

public class KegFluidTankNeoForge
extends FluidTank
implements AbstractedFluidTank {
    public KegFluidTankNeoForge(int capacity) {
        super(capacity);
    }

    @Override
    public long getFluidCapacity(int slot) {
        return this.getCapacity();
    }

    @Override
    public AbstractedFluidStack getAbstractedFluid() {
        return new AbstractedFluidStack(this.fluid.getFluid(), this.fluid.getAmount(), (DataComponentMap)this.fluid.getComponents(), FluidUnit.MILLIBUCKET, this.fluid);
    }

    @Override
    public void setAbstractedFluid(AbstractedFluidStack stack) {
        this.setFluid(this.unwrapFluid(stack));
    }

    @Override
    public AbstractedFluidStack fill(AbstractedFluidStack fluidStack, boolean simulate) {
        this.fill(this.unwrapFluid(fluidStack), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        return this.getAbstractedFluid();
    }

    @Override
    public AbstractedFluidStack drain(int slot, long maxDrain, FluidUnit unit, boolean simulate) {
        int newAmount = (int)unit.convertToLoader(maxDrain);
        FluidStack fluid = this.drain(newAmount, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        return new AbstractedFluidStack(fluid.getFluid(), fluid.getAmount(), (DataComponentMap)fluid.getComponents(), FluidUnit.MILLIBUCKET, fluid);
    }

    @Override
    public void readFromNbt(CompoundTag tag, HolderLookup.Provider provider) {
        this.readFromNBT(provider, tag);
    }

    @Override
    public CompoundTag writeToNbt(HolderLookup.Provider provider) {
        return this.writeToNBT(provider, new CompoundTag());
    }

    private FluidStack unwrapFluid(AbstractedFluidStack stack) {
        DataComponentPatch dataComponentPatch;
        Object object = stack.loaderSpecific();
        if (object instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)object;
            return fluidStack;
        }
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Holder.Reference reference = stack.fluid().builtInRegistryHolder();
        int n = (int)stack.unit().convertToLoader(stack.amount());
        object = stack.components();
        if (object instanceof PatchedDataComponentMap) {
            PatchedDataComponentMap patched = (PatchedDataComponentMap)object;
            dataComponentPatch = patched.asPatch();
        } else {
            dataComponentPatch = DataComponentPatch.EMPTY;
        }
        return new FluidStack((Holder)reference, n, dataComponentPatch);
    }
}

