/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.commands;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.config.ATLProperties;
import dev.uncandango.alltheleaks.diag.common.mods.minecraft.DebugNativeImage;
import dev.uncandango.alltheleaks.feature.common.mods.minecraft.MemoryMonitor;
import dev.uncandango.alltheleaks.mixin.Trackable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModList;
import org.embeddedt.modernfix.world.ThreadDumper;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public final class ATLCommands {
    public static void registerClientCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"atl").then(Commands.literal((String)"run_explicit_gc").executes(cmd -> ATLCommands.runGc((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"clear_native_images").executes(cmd -> ATLCommands.clearNativeImages((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"force_refresh").executes(cmd -> ATLCommands.checkLeaking((CommandSourceStack)cmd.getSource(), true)))).then(Commands.literal((String)"reset_statistics").executes(cmd -> ATLCommands.resetStatistics((CommandSourceStack)cmd.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"thread_dump").requires(source -> ModList.get().isLoaded("modernfix"))).executes(cmd -> ATLCommands.doModernFixThreadDump((CommandSourceStack)cmd.getSource()))));
    }

    private static int doModernFixThreadDump(CommandSourceStack source) {
        AllTheLeaks.LOGGER.error(ThreadDumper.obtainThreadDump());
        source.sendSystemMessage((Component)Component.literal((String)"Thread dump done, check latest.log"));
        return 1;
    }

    private static int resetStatistics(CommandSourceStack source) {
        ATLCommands.runGc(source);
        MemoryMonitor.Statistics.reset();
        return 1;
    }

    public static void registerServerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"atl").then(Commands.literal((String)"run_explicit_gc").executes(cmd -> ATLCommands.runGc((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"force_refresh").executes(cmd -> ATLCommands.checkLeaking((CommandSourceStack)cmd.getSource(), true)))).then(Commands.literal((String)"reset_statistics").executes(cmd -> ATLCommands.resetStatistics((CommandSourceStack)cmd.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"thread_dump").requires(source -> ModList.get().isLoaded("modernfix"))).executes(cmd -> ATLCommands.doModernFixThreadDump((CommandSourceStack)cmd.getSource()))));
    }

    public static int checkLeaking(CommandSourceStack source, boolean shouldRunGc) {
        if (shouldRunGc && ATLCommands.runGc(source) == 0) {
            return 0;
        }
        Trackable.clearNullReferences();
        AllTheLeaks.LOGGER.info("Logging events from checking leak");
        MemoryMonitor.getEventsSummary().forEach(arg_0 -> ((Logger)AllTheLeaks.LOGGER).info(arg_0));
        ArrayList lines = new ArrayList();
        Trackable.getSummary().forEach((baseClazz, summaryMap) -> {
            if (summaryMap.isEmpty()) {
                return;
            }
            lines.add(Component.translatable((String)"%s:", (Object[])new Object[]{baseClazz.getSimpleName()}));
            summaryMap.forEach((innerClazz, count) -> {
                Module module = innerClazz.getModule();
                if (module != null) {
                    lines.add(Component.translatable((String)"- %s (%s): %s", (Object[])new Object[]{innerClazz.getSimpleName(), module.getName(), count}));
                } else {
                    lines.add(Component.translatable((String)"- %s: %s", (Object[])new Object[]{innerClazz.getSimpleName(), count}));
                }
            });
        });
        if (lines.isEmpty()) {
            source.sendSystemMessage((Component)Component.literal((String)"No leak was found so far...").withStyle(ChatFormatting.GREEN));
        } else {
            source.sendSystemMessage((Component)Component.literal((String)"Listing leaks...").withStyle(ChatFormatting.YELLOW));
            lines.forEach(arg_0 -> ((CommandSourceStack)source).sendSystemMessage(arg_0));
        }
        return 1;
    }

    private static int clearNativeImages(CommandSourceStack source) {
        if (!ATLProperties.get().debugNativeImage) {
            source.sendFailure((Component)Component.literal((String)"DebugNativeImage is disabled, activate it at config/alltheleaks.json"));
            return 0;
        }
        AtomicInteger counter = new AtomicInteger();
        DebugNativeImage.NATIVE_IMAGES_TRACKER.forEach((k, v) -> {
            Set setWithEmptyRef = Collections.synchronizedSet(new HashSet());
            v.forEach(wr -> {
                NativeImage ref = (NativeImage)wr.imageRef().get();
                if (ref == null) {
                    setWithEmptyRef.add(wr);
                }
            });
            if (!v.isEmpty() && setWithEmptyRef.size() == v.size()) {
                AllTheLeaks.LOGGER.info("Removed all NativeImages for key {}", k);
                if (k.useStbFree()) {
                    STBImage.nstbi_image_free((long)k.pixels());
                } else {
                    MemoryUtil.nmemFree((long)k.pixels());
                }
                setWithEmptyRef.forEach(wr -> {
                    counter.getAndIncrement();
                    AllTheLeaks.LOGGER.info("Printing stack trace for: {}", (Object)wr.description());
                    boolean reachedInit = false;
                    for (StackTraceElement trace : wr.stackTraceElements()) {
                        if (!reachedInit) {
                            reachedInit = trace.getMethodName().contains("init");
                        }
                        if (!reachedInit) continue;
                        System.out.println("\tat " + trace.getClassName() + "." + trace.getMethodName() + "(" + trace.getFileName() + ":" + trace.getLineNumber() + ")");
                    }
                });
                v.clear();
            }
        });
        source.sendSuccess(() -> Component.literal((String)("Cleared " + counter.get() + " NativeImages")), true);
        return 1;
    }

    public static int runGc(CommandSourceStack source) {
        if (!MemoryMonitor.runExplicitGc()) {
            source.sendFailure((Component)Component.literal((String)"Explicit GC is disabled, remove arguments -XX:+DisableExplicitGC"));
            return 0;
        }
        return 1;
    }
}

