/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.type.capability;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.ApiStatus;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.platform.Services;

public interface ICurioItem {
    public static final ICurio defaultInstance = () -> ItemStack.EMPTY;

    default public boolean hasCurioCapability(ItemStack stack) {
        return true;
    }

    default public void curioTick(SlotContext slotContext, ItemStack stack) {
        defaultInstance.curioTick(slotContext);
    }

    default public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        defaultInstance.onEquip(slotContext, prevStack);
    }

    default public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        defaultInstance.onUnequip(slotContext, newStack);
    }

    default public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return defaultInstance.canEquip(slotContext);
    }

    default public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return defaultInstance.canUnequip(slotContext);
    }

    default public List<Component> getSlotsTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        return defaultInstance.getSlotsTooltip(tooltips, context);
    }

    @Deprecated(forRemoval=true, since="1.22")
    default public List<Component> getSlotsTooltip(List<Component> tooltips, ItemStack stack) {
        return defaultInstance.getSlotsTooltip(tooltips, Item.TooltipContext.EMPTY);
    }

    default public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        return defaultInstance.getAttributeModifiers(slotContext, id);
    }

    @Deprecated(forRemoval=true, since="1.21")
    default public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        return defaultInstance.getAttributeModifiers(slotContext, ResourceLocation.withDefaultNamespace((String)"empty"));
    }

    default public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        defaultInstance.onEquipFromUse(slotContext);
    }

    @Nonnull
    default public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return defaultInstance.getEquipSound(slotContext);
    }

    default public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return defaultInstance.canEquipFromUse(slotContext);
    }

    default public void curioBreak(SlotContext slotContext, ItemStack stack) {
        defaultInstance.curioBreak(slotContext);
    }

    default public boolean canSync(SlotContext slotContext, ItemStack stack) {
        return defaultInstance.canSync(slotContext);
    }

    @Nonnull
    default public CompoundTag writeSyncData(SlotContext slotContext, ItemStack stack) {
        return defaultInstance.writeSyncData(slotContext);
    }

    default public void readSyncData(SlotContext slotContext, CompoundTag compound, ItemStack stack) {
        defaultInstance.readSyncData(slotContext, compound);
    }

    @Nonnull
    default public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, boolean recentlyHit, ItemStack stack) {
        return this.getDropRule(slotContext, source, 0, recentlyHit, stack);
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    @Nonnull
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    default public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return defaultInstance.getDropRule(slotContext, source, recentlyHit);
    }

    default public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        return defaultInstance.getAttributesTooltip(tooltips, context);
    }

    @Deprecated(forRemoval=true, since="1.22")
    default public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        return defaultInstance.getAttributesTooltip(tooltips, Item.TooltipContext.EMPTY);
    }

    default public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
        return defaultInstance.getFortuneLevel(slotContext, lootContext);
    }

    default public int getLootingLevel(SlotContext slotContext, @Nullable LootContext lootContext, ItemStack stack) {
        return defaultInstance.getLootingLevel(slotContext, lootContext);
    }

    default public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return Services.CURIOS.makesPiglinsNeutral(stack, slotContext.entity());
    }

    default public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        return Services.CURIOS.canWalkOnPowderedSnow(stack, slotContext.entity());
    }

    default public boolean isEnderMask(SlotContext slotContext, EnderMan enderMan, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return Services.CURIOS.isEnderMask(stack, player, enderMan);
        }
        return false;
    }
}

