/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyWeb;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class RedstoneHoneyWeb
extends HoneyWeb {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    private static final Vector3f[] COLORS = (Vector3f[])Util.make((Object)new Vector3f[16], vec3s -> {
        for (int powerLevel = 0; powerLevel <= 15; ++powerLevel) {
            float brightness;
            float red = brightness * 0.6f + ((brightness = (float)powerLevel / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float green = Mth.clamp((float)(brightness * brightness * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float blue = Mth.clamp((float)(brightness * brightness * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            vec3s[powerLevel] = new Vec3((double)red, (double)green, (double)blue).toVector3f();
        }
    });
    public static final MapCodec<RedstoneHoneyWeb> CODEC = Block.simpleCodec(RedstoneHoneyWeb::new);

    public RedstoneHoneyWeb() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).forceSolidOn().lightLevel(blockState -> ((Integer)blockState.getValue((Property)POWER) + 9) / 10).noCollission().requiresCorrectToolForDrops().strength(4.0f).pushReaction(PushReaction.DESTROY));
    }

    public RedstoneHoneyWeb(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EASTWEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UPDOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends RedstoneHoneyWeb> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{NORTHSOUTH, EASTWEST, UPDOWN, POWER});
    }

    @Override
    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        super.entityInside(blockState, level, blockPos, entity);
        VoxelShape shape = this.shapeByIndex[this.getAABBIndex(blockState)];
        shape = shape.move((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        if (Shapes.joinIsNotEmpty((VoxelShape)shape, (VoxelShape)Shapes.create((AABB)entity.getBoundingBox()), (BooleanOp)BooleanOp.AND) && blockState.is((Block)this) && (Integer)blockState.getValue((Property)POWER) != 15) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWER, (Comparable)Integer.valueOf(15)), 3);
            level.scheduleTick(new BlockPos((Vec3i)blockPos), (Block)this, 10);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ((GenericTrigger)((Object)BzCriterias.TRIGGER_REDSTONE_HONEY_WEB_TRIGGER.get())).trigger(serverPlayer);
            }
        }
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if ((Integer)serverLevel.getBlockState(blockPos).getValue((Property)POWER) == 15) {
            boolean noEntitiesInbounds = true;
            List list = serverLevel.getEntities(null, blockState.getShape((BlockGetter)serverLevel, blockPos).bounds().move(blockPos));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (entity.isIgnoringBlockTriggers()) continue;
                    noEntitiesInbounds = false;
                    break;
                }
            }
            if (noEntitiesInbounds) {
                serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWER, (Comparable)Integer.valueOf(0)), 3);
            } else {
                serverLevel.scheduleTick(new BlockPos((Vec3i)blockPos), (Block)this, 10);
            }
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        return super.getStateForPlacement(placeContext);
    }

    public void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean pushed) {
        if (!blockState1.is(blockState.getBlock()) && !level.isClientSide) {
            this.updatePowerStrength(level, blockState, blockPos);
            for (Direction direction : Direction.Plane.VERTICAL) {
                level.updateNeighborsAt(blockPos.relative(direction), (Block)this);
            }
        }
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean pushed) {
        if (!pushed && !blockState.is(blockState1.getBlock())) {
            super.onRemove(blockState, level, blockPos, blockState1, false);
            if (!level.isClientSide) {
                for (Direction direction : Direction.values()) {
                    level.updateNeighborsAt(blockPos.relative(direction), (Block)this);
                }
            }
        }
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos1, boolean b) {
        if (!level.isClientSide && blockState.is((Block)this) && (Integer)blockState.getValue((Property)POWER) != 15) {
            this.updatePowerStrength(level, blockState, blockPos);
        }
    }

    private void updatePowerStrength(Level level, BlockState blockState, BlockPos blockPos) {
        int currentPower = this.calculateTargetStrength(level, blockState, blockPos);
        if ((Integer)blockState.getValue((Property)POWER) != currentPower && level.getBlockState(blockPos) == blockState && level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWER, (Comparable)Integer.valueOf(currentPower)), 3)) {
            for (Direction direction : Direction.values()) {
                level.updateNeighborsAt(blockPos.relative(direction), (Block)this);
            }
        }
    }

    private int calculateTargetStrength(Level level, BlockState centerState, BlockPos blockPos) {
        int decreasingPower = 0;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos2 = blockPos.relative(direction);
            BlockState neighborState = level.getBlockState(blockpos2);
            decreasingPower = Math.max(decreasingPower, this.getWireSignal(centerState, neighborState));
        }
        return Math.max(0, decreasingPower - 1);
    }

    private int getWireSignal(BlockState centerState, BlockState neighborState) {
        if (neighborState.is((Block)this)) {
            if (((Boolean)centerState.getValue((Property)NORTHSOUTH)).booleanValue() && ((Boolean)neighborState.getValue((Property)NORTHSOUTH)).booleanValue()) {
                return (Integer)neighborState.getValue((Property)POWER);
            }
            if (((Boolean)centerState.getValue((Property)EASTWEST)).booleanValue() && ((Boolean)neighborState.getValue((Property)EASTWEST)).booleanValue()) {
                return (Integer)neighborState.getValue((Property)POWER);
            }
            if (((Boolean)centerState.getValue((Property)UPDOWN)).booleanValue() && ((Boolean)neighborState.getValue((Property)UPDOWN)).booleanValue()) {
                return (Integer)neighborState.getValue((Property)POWER);
            }
        }
        return 0;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState thisState, BlockGetter blockAccess, BlockPos pos, Direction direction) {
        int power = (Integer)thisState.getValue((Property)POWER);
        BlockState parentState = blockAccess.getBlockState(pos.relative(direction.getOpposite()));
        if (power > 0 && !parentState.is((Block)this)) {
            if (direction.getAxis() != Direction.Axis.X && ((Boolean)thisState.getValue((Property)NORTHSOUTH)).booleanValue()) {
                return power;
            }
            if (direction.getAxis() != Direction.Axis.Z && ((Boolean)thisState.getValue((Property)EASTWEST)).booleanValue()) {
                return power;
            }
            if (direction.getAxis() != Direction.Axis.Y && ((Boolean)thisState.getValue((Property)UPDOWN)).booleanValue()) {
                return power;
            }
        }
        return 0;
    }

    public int getDirectSignal(BlockState blockstate, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    @Override
    public void animateTick(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        super.animateTick(blockState, world, position, random);
        int power = (Integer)blockState.getValue((Property)POWER);
        if (power != 0) {
            for (int i = 0; i == random.nextInt(35); ++i) {
                this.addRedstoneParticle(world, random, position, blockState.getShape((BlockGetter)world, position), power);
            }
        }
    }

    private void addRedstoneParticle(Level world, RandomSource random, BlockPos blockPos, VoxelShape blockShape, int power) {
        this.addRedstoneParticle(world, random, (double)blockPos.getX() + blockShape.min(Direction.Axis.X), (double)blockPos.getX() + blockShape.max(Direction.Axis.X), (double)blockPos.getY() + blockShape.min(Direction.Axis.Y), (double)blockPos.getY() + blockShape.max(Direction.Axis.Y), (double)blockPos.getZ() + blockShape.min(Direction.Axis.Z), (double)blockPos.getZ() + blockShape.max(Direction.Axis.Z), power);
    }

    private void addRedstoneParticle(Level world, RandomSource random, double xMin, double xMax, double yMin, double yMax, double zMax, double zMin, int power) {
        world.addParticle((ParticleOptions)new DustParticleOptions(COLORS[power], 1.0f), Mth.lerp((double)random.nextDouble(), (double)xMin, (double)xMax), Mth.lerp((double)random.nextDouble(), (double)yMin, (double)yMax), Mth.lerp((double)random.nextDouble(), (double)zMax, (double)zMin), 0.0, 0.0, 0.0);
    }
}

