/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.particles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.client.ParticleEngineAccessor;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class TradeHintParticle
extends Particle {
    public static final int TRADE_REWARD_CYCLE_TIME = 40;
    public static final double PARTICLE_Y_OFFSET = 4.5;
    public static final ResourceLocation SPEECH_BUBBLE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"trade_hint/1");
    private final RenderBuffers renderBuffers;
    private final ItemRenderer itemRenderer;
    private final Item tradeWantItem;
    private final List<ItemStack> tradeRewardItems;
    protected TextureAtlasSprite sprite;
    private int life;
    private float pastAnimationProgress;

    public TradeHintParticle(ItemRenderer itemRenderer, RenderBuffers arg2, ClientLevel arg3, Entity queen, Item tradeWantItem, List<ItemStack> tradeRewardItems) {
        super(arg3, queen.getX(), queen.getY() + 4.5, queen.getZ(), 0.0, 0.0, 0.0);
        this.renderBuffers = arg2;
        this.tradeWantItem = tradeWantItem;
        this.tradeRewardItems = tradeRewardItems;
        this.itemRenderer = itemRenderer;
        this.sprite = ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).bumblezone$getTextureAtlas().getSprite(SPEECH_BUBBLE_TEXTURE);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer doNotUse, Camera camera, float partialTick) {
        Quaternionf cameraRotationQuat;
        float animationProgress;
        if (!BzClientConfigs.showBeeQueenSpeechBubble) {
            return;
        }
        this.pastAnimationProgress = animationProgress = this.getAnimationProgressForCurrentLife(partialTick);
        if (this.roll == 0.0f) {
            cameraRotationQuat = new Quaternionf((Quaternionfc)camera.rotation());
        } else {
            cameraRotationQuat = new Quaternionf((Quaternionfc)camera.rotation());
            cameraRotationQuat.rotateZ(Mth.lerp((float)partialTick, (float)this.oRoll, (float)this.roll));
        }
        cameraRotationQuat.rotateAxis((float)Math.PI, 0.0f, 1.0f, 0.0f);
        float offset = 1.0f - animationProgress;
        Vector3f offsetVec = new Vector3f(-offset, -offset, 0.0f);
        offsetVec.rotate((Quaternionfc)cameraRotationQuat);
        Vec3 vec3 = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - vec3.x()) + offsetVec.x();
        float y = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - vec3.y()) + offsetVec.y();
        float z = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - vec3.z()) + offsetVec.z();
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int k = 0; k < 4; ++k) {
            Vector3f vector3f = vector3fs[k];
            vector3f.rotate((Quaternionfc)cameraRotationQuat);
            vector3f.mul(animationProgress);
            vector3f.add(x, y, z);
        }
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        int lightColor = 240;
        MultiBufferSource.BufferSource bufferSource = this.renderBuffers.bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.text((ResourceLocation)TextureAtlas.LOCATION_PARTICLES));
        vertexConsumer.addVertex(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv(u1, v1).setLight(lightColor);
        vertexConsumer.addVertex(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv(u1, v0).setLight(lightColor);
        vertexConsumer.addVertex(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv(u0, v0).setLight(lightColor);
        vertexConsumer.addVertex(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv(u0, v1).setLight(lightColor);
        bufferSource.endBatch();
        Quaternionf reverseQuad = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        reverseQuad.rotateAxis((float)Math.PI, 0.0f, 1.0f, 0.0f);
        Quaternionf normalToUse = new Quaternionf(-0.3f, 0.0f, 0.0f, 1.0f);
        PoseStack wantPoseStack = new PoseStack();
        TradeHintParticle.setupPoseStack(wantPoseStack, x, y, z, 0.35f, 0.437f, -0.001f, animationProgress, cameraRotationQuat, reverseQuad, normalToUse);
        ItemStack wantItemStack = this.tradeWantItem.getDefaultInstance();
        this.renderItem(wantItemStack, wantPoseStack, bufferSource);
        PoseStack rewardPoseStack = new PoseStack();
        TradeHintParticle.setupPoseStack(rewardPoseStack, x, y, z, -0.32f, -0.15f, -0.001f, animationProgress, cameraRotationQuat, reverseQuad, normalToUse);
        ItemStack rewardItemStack = this.tradeRewardItems.get(this.life / 40 % this.tradeRewardItems.size());
        this.renderItem(rewardItemStack, rewardPoseStack, bufferSource);
        rewardPoseStack.popPose();
        bufferSource.endBatch();
    }

    private static void setupPoseStack(PoseStack poseStack, float x, float y, float z, float xOffset, float yOffset, float zOffset, float size, Quaternionf quaternionf, Quaternionf reverseQuad, Quaternionf normalToUse) {
        poseStack.pushPose();
        poseStack.last().pose().translate(x, y, z);
        poseStack.last().pose().scale(size, size, size);
        poseStack.last().pose().rotateAround((Quaternionfc)quaternionf, 0.0f, 0.0f, 0.0f);
        poseStack.last().pose().translate(xOffset, yOffset, zOffset);
        poseStack.last().pose().scale(0.5f, 0.5f, 0.001f);
        poseStack.last().pose().rotateAround((Quaternionfc)reverseQuad, 0.0f, 0.0f, 0.0f);
        poseStack.last().normal().set((Quaternionfc)normalToUse);
    }

    private float getAnimationProgressForCurrentLife(float partialTick) {
        float animationProgress = 1.0f;
        float animationChangeTime = 20.0f;
        if ((float)this.life <= animationChangeTime) {
            float currentProgress = (float)this.life / animationChangeTime;
            float c1 = 1.70158f;
            float c3 = c1 + 1.0f;
            float calcSize = (float)(1.0 + (double)c3 * Math.pow(currentProgress - 1.0f, 3.0) + (double)c1 * Math.pow(currentProgress - 1.0f, 2.0));
            animationProgress = Mth.lerp((float)partialTick, (float)this.pastAnimationProgress, (float)calcSize);
        } else if ((float)(200 - this.life) <= animationChangeTime / 2.0f) {
            float currentProgress = (float)(200 - this.life) / (animationChangeTime / 2.0f);
            float calcSize = (float)(1.0 - Math.cos((double)currentProgress * Math.PI / 2.0));
            animationProgress = Mth.lerp((float)partialTick, (float)this.pastAnimationProgress, (float)calcSize);
        }
        return animationProgress;
    }

    private void renderItem(ItemStack itemStack, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource) {
        BakedModel bakedmodel = this.itemRenderer.getModel(itemStack, (Level)Minecraft.getInstance().level, null, 0);
        this.itemRenderer.render(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
    }

    public void tick() {
        ++this.life;
        if (this.life == 200) {
            this.remove();
        }
    }
}

