/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.datamanagers.pollenpuffentityflowers;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.utils.BzNbtPredicate;
import com.telepathicgrunt.the_bumblezone.utils.LenientUnboundedMapCodec;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public class PollenPuffEntityPollinateManager
extends SimpleJsonResourceReloadListener {
    public static final PollenPuffEntityPollinateManager POLLEN_PUFF_ENTITY_POLLINATE_MANAGER = new PollenPuffEntityPollinateManager();
    public static final Codec<Map<EntityType<?>, List<EntryObject>>> CODEC = new LenientUnboundedMapCodec(ResourceLocation.CODEC.comapFlatMap(r -> {
        Optional entityTypeOptional = BuiltInRegistries.ENTITY_TYPE.getOptional(r);
        if (entityTypeOptional.isPresent()) {
            return DataResult.success((Object)((EntityType)entityTypeOptional.get()));
        }
        if (PlatformHooks.isModLoaded(r.getNamespace())) {
            Bumblezone.LOGGER.error("Bz Pollination File Reading Error - Unknown EntityType:  " + String.valueOf(r));
            return DataResult.error(() -> "Bz Error - Unknown EntityType:  " + String.valueOf(r) + "  - ");
        }
        return DataResult.error(() -> "Bz Error - Target mod not present");
    }, arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ENTITY_TYPE).getKey(arg_0)), Codec.list(EntryObject.ENTRY_CODEC));
    public final Map<EntityType<?>, List<EntryObject>> mobToPlants = new Object2ObjectArrayMap();

    public PollenPuffEntityPollinateManager() {
        super(Bumblezone.GSON, "bz_pollen_puff_entity_flowers");
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        this.mobToPlants.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                DataResult mapDataResult = CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement);
                mapDataResult.error().ifPresent(e -> {
                    if (!e.message().contains("Bz Error - Target mod not present")) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse pollen puff entity to flower file {} - Error: {}", fileIdentifier, e);
                    }
                });
                Map newMap = mapDataResult.resultOrPartial(s -> {}).orElse(new HashMap());
                newMap.forEach((e, v) -> {
                    if (this.mobToPlants.containsKey(e)) {
                        this.mobToPlants.get(e).addAll((Collection<EntryObject>)v);
                    } else {
                        this.mobToPlants.put((EntityType<?>)e, (List<EntryObject>)v);
                    }
                });
            }
            catch (Exception e2) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse pollen puff entity to flower file: {}", fileIdentifier, (Object)e2);
            }
        });
    }

    public WeightedStateProvider getPossiblePlants(Entity entity) {
        if (this.mobToPlants.containsKey(entity.getType())) {
            for (EntryObject entryObject : this.mobToPlants.get(entity.getType())) {
                if (!entryObject.nbtPredicate().matches(entity)) continue;
                return entryObject.weightedStateProvider();
            }
        }
        return null;
    }

    public record EntryObject(BzNbtPredicate nbtPredicate, WeightedStateProvider weightedStateProvider) {
        public static final Codec<EntryObject> ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BzNbtPredicate.CODEC.fieldOf("nbt_match").orElse((Object)BzNbtPredicate.ANY).forGetter(config -> config.nbtPredicate), (App)WeightedStateProvider.CODEC.fieldOf("plants_to_spawn").forGetter(config -> config.weightedStateProvider)).apply((Applicative)instance, instance.stable(EntryObject::new)));
    }
}

