/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.emi;

import com.telepathicgrunt.the_bumblezone.modcompat.EMICompat;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.DrawableWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class EMIQueenTradesInfo
implements EmiRecipe {
    private final EmiIngredient input;
    private final TagKey<Item> inputTag;
    private final List<EmiStack> outputs;
    private final TagKey<Item> outputTag;
    private final EmiIngredient visualOutputs;
    private final int xpReward;
    private final int weight;
    private final int groupWeight;
    private final ResourceLocation id;

    public EMIQueenTradesInfo(EmiIngredient input, TagKey<Item> inputTag, List<EmiStack> outputs, TagKey<Item> outputTag, int xp, int weight, int groupWeight, ResourceLocation id) {
        this.input = input;
        this.inputTag = inputTag;
        this.outputs = outputs;
        this.outputTag = outputTag;
        this.visualOutputs = EmiIngredient.of(outputs);
        this.xpReward = xp;
        this.weight = weight;
        this.groupWeight = groupWeight;
        this.id = id;
    }

    public int getXpReward() {
        return this.xpReward;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getGroupWeight() {
        return this.groupWeight;
    }

    public TagKey<Item> getInputTag() {
        return this.inputTag;
    }

    public TagKey<Item> getOutputTag() {
        return this.outputTag;
    }

    public EmiRecipeCategory getCategory() {
        return EMICompat.QUEEN_TRADES;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 124;
    }

    public int getDisplayHeight() {
        return 28;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)new TextureWidget(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/queen_trades_layout.png"), 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 0, 0));
        widgets.add((Widget)new SlotWidget(this.input, 5, 5));
        widgets.add((Widget)new SlotWidget(this.visualOutputs, 63, 5).recipeContext((EmiRecipe)this));
        widgets.add((Widget)new TextWidget(Component.translatable((String)"the_bumblezone.recipe_viewers.queen_trade_xp", (Object[])new Object[]{this.getXpReward()}).getVisualOrderText(), 100, 11, -12566464, false));
        if (this.getInputTag() != null) {
            widgets.add((Widget)new TextureWidget(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/tag_icon.png"), 11, 11, 16, 16, 0, 0, 16, 16, 16, 16));
        }
        if (this.getOutputTag() != null) {
            widgets.add((Widget)new TextureWidget(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/tag_icon.png"), 69, 11, 16, 16, 0, 0, 16, 16, 16, 16));
        }
        double percentValue = (double)this.getWeight() / (double)this.getGroupWeight() * 100.0;
        String percent = String.valueOf(percentValue);
        String percentRounded = percentValue < 1.0 ? String.valueOf(Math.max((double)Math.round(percentValue * 10.0) / 10.0, 0.1)) : String.valueOf(Math.max(Math.round(percentValue), 1L));
        DrawableWidget tooltipWidget = new DrawableWidget(32, 2, 22, 20, (matrices, mouseX, mouseY, delta) -> {});
        tooltipWidget.tooltip((x, z) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"the_bumblezone.recipe_viewers.queen_trade_chance_tooltip", (Object[])new Object[]{percent.substring(0, Math.min(percent.length(), 5))}).getVisualOrderText())));
        widgets.add((Widget)tooltipWidget);
        widgets.add((Widget)new TextWidget(Component.translatable((String)"the_bumblezone.recipe_viewers.queen_trade_chance_text", (Object[])new Object[]{percentRounded}).getVisualOrderText(), 38 - (percentValue < 1.0 ? 6 : percentRounded.length() * 3), 11, -12566464, false));
    }
}

