/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import java.util.Map;
import java.util.function.Supplier;

public class SuppliedMap<K, V> {
    private final Map<K, V> map;
    private Map<Supplier<K>, Supplier<V>> suppliers;

    public SuppliedMap(Map<K, V> backingMap, Map<Supplier<K>, Supplier<V>> backingSupplierMap) {
        this.map = backingMap;
        this.suppliers = backingSupplierMap;
    }

    public void put(Supplier<K> key, Supplier<V> value) {
        if (this.suppliers == null) {
            this.map.put(key.get(), value.get());
        } else {
            this.suppliers.put(key, value);
        }
    }

    private void supply() {
        if (this.suppliers == null) {
            return;
        }
        for (Map.Entry<Supplier<K>, Supplier<V>> entry : this.suppliers.entrySet()) {
            this.map.put(entry.getKey().get(), entry.getValue().get());
        }
        this.suppliers.clear();
        this.suppliers = null;
    }

    public V get(K key) {
        this.supply();
        return this.map.get(key);
    }

    public V getOrDefault(K key, V defaultValue) {
        this.supply();
        return this.map.getOrDefault(key, defaultValue);
    }
}

