/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyWeb;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WebCeiling
extends Feature<NoneFeatureConfiguration> {
    public WebCeiling(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.level());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.set((Vec3i)context.origin()).move(Direction.UP);
        if (!bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos).isAir() && bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos.move(Direction.DOWN)).is(Blocks.AIR)) {
            Direction.Axis chosenAxis = context.random().nextBoolean() ? Direction.Axis.X : Direction.Axis.Z;
            int chosenLength = 5 + context.random().nextInt(4);
            for (int i = 0; i < chosenLength && bulkSectionAccess.getBlockState((BlockPos)mutableBlockPos).isAir(); ++i) {
                Block newBlock = i > chosenLength / 2 ? (Block)BzBlocks.HONEY_WEB.get() : (Block)BzBlocks.REDSTONE_HONEY_WEB.get();
                BlockState newState = (BlockState)newBlock.defaultBlockState().setValue((Property)HoneyWeb.AXIS_TO_PROP.get(chosenAxis), (Comparable)Boolean.valueOf(true));
                bulkSectionAccess.setBlockState((BlockPos)mutableBlockPos, newState, false);
                mutableBlockPos.move(Direction.DOWN);
            }
            return true;
        }
        return false;
    }
}

