/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class HoneycombHoleProcessor
extends StructureProcessor {
    public static final MapCodec<HoneycombHoleProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("flood_level").forGetter(config -> config.floodLevel)).apply((Applicative)instance, instance.stable(HoneycombHoleProcessor::new)));
    private final int floodLevel;

    private HoneycombHoleProcessor(int floodLevel) {
        this.floodLevel = floodLevel;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        RandomSource random;
        BlockPos worldPos = structureBlockInfoWorld.pos();
        if (GeneralUtils.isOutsideStructureAllowedBounds(settings, worldPos)) {
            return structureBlockInfoWorld;
        }
        BlockState placingState = structureBlockInfoWorld.state();
        ChunkAccess chunk = levelReader.getChunk(structureBlockInfoWorld.pos());
        LevelChunkSection chunkSection = chunk.getSection(levelReader.getSectionIndex(worldPos.getY()));
        BlockState checkedState = HoneycombHoleProcessor.getBlockStateFromSection(chunkSection, worldPos);
        if (checkedState.isAir() || !checkedState.getFluidState().isEmpty()) {
            if (placingState.isAir() || placingState.is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
                if (!checkedState.getFluidState().isEmpty() || worldPos.getY() <= this.floodLevel) {
                    HoneycombHoleProcessor.setBlockStateFromSection(chunkSection, worldPos, ((LiquidBlock)BzFluids.SUGAR_WATER_BLOCK.get()).defaultBlockState());
                    if (checkedState.hasBlockEntity()) {
                        chunk.removeBlockEntity(worldPos);
                    }
                    return null;
                }
            } else {
                return null;
            }
        }
        if (placingState.is((Block)BzBlocks.HONEYCOMB_BROOD.get())) {
            RandomSource random2;
            if (checkedState.hasBlockEntity()) {
                chunk.removeBlockEntity(worldPos);
            }
            if ((random2 = settings.getRandom(worldPos)).nextInt(5) < 2) {
                return new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)placingState.setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(random2.nextInt(3))), null);
            }
            if (random2.nextInt(13) == 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)((Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get()).defaultBlockState().setValue((Property)EmptyHoneycombBrood.FACING, (Comparable)((Direction)placingState.getValue((Property)HoneycombBrood.FACING))), null);
            }
            if (random2.nextInt(4) == 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.HONEY_BLOCK.defaultBlockState(), null);
        }
        if (placingState.is(Blocks.HONEY_BLOCK) || placingState.is((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            RandomSource random3;
            if (checkedState.hasBlockEntity()) {
                chunk.removeBlockEntity(worldPos);
            }
            if ((random3 = settings.getRandom(worldPos)).nextInt(3) == 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.HONEY_BLOCK.defaultBlockState(), null);
        }
        if (placingState.is((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            RandomSource random4;
            BlockState belowState = chunk.getBlockState(worldPos.below());
            if (belowState.isAir() || !belowState.getFluidState().isEmpty()) {
                return null;
            }
            if (checkedState.hasBlockEntity()) {
                chunk.removeBlockEntity(worldPos);
            }
            if ((random4 = settings.getRandom(worldPos)).nextInt(80) != 0) {
                return new StructureTemplate.StructureBlockInfo(worldPos, Blocks.CAVE_AIR.defaultBlockState(), null);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)((Block)BzBlocks.PILE_OF_POLLEN.get()).defaultBlockState().setValue((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(random4.nextInt(3) + 1)), null);
        }
        if (placingState.is(Blocks.HONEYCOMB_BLOCK) && (random = settings.getRandom(worldPos)).nextInt(3) != 0) {
            if (checkedState.hasBlockEntity()) {
                chunk.removeBlockEntity(worldPos);
            }
            return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState(), null);
        }
        if (checkedState.hasBlockEntity()) {
            chunk.removeBlockEntity(worldPos);
        }
        return structureBlockInfoWorld;
    }

    private static BlockState getBlockStateFromSection(LevelChunkSection chunkSection, BlockPos blockPos) {
        int i = SectionPos.sectionRelative((int)blockPos.getX());
        int j = SectionPos.sectionRelative((int)blockPos.getY());
        int k = SectionPos.sectionRelative((int)blockPos.getZ());
        return chunkSection.getBlockState(i, j, k);
    }

    private static void setBlockStateFromSection(LevelChunkSection chunkSection, BlockPos blockPos, BlockState newState) {
        int i = SectionPos.sectionRelative((int)blockPos.getX());
        int j = SectionPos.sectionRelative((int)blockPos.getY());
        int k = SectionPos.sectionRelative((int)blockPos.getZ());
        chunkSection.setBlockState(i, j, k, newState);
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.HONEYCOMB_HOLE_PROCESSOR.get();
    }
}

