/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TagReplaceProcessor
extends StructureProcessor {
    public static final MapCodec<TagReplaceProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("output_block_tag").forGetter(config -> config.outputBlockTag), (App)TagKey.codec((ResourceKey)Registries.BLOCK).optionalFieldOf("blacklisted_output_block_tag").forGetter(config -> config.blacklistedOutputBlockTag), (App)Codec.BOOL.fieldOf("double_tall_flower").orElse((Object)false).forGetter(config -> config.doubleTallFlower), (App)Codec.BOOL.fieldOf("same_throughout_piece").orElse((Object)false).forGetter(config -> config.sameThroughoutPiece), (App)Codec.INT.fieldOf("seed_random_addition").orElse((Object)0).forGetter(config -> config.seedRandomAddition)).apply((Applicative)instance, instance.stable(TagReplaceProcessor::new)));
    private final Block inputBlock;
    private final TagKey<Block> outputBlockTag;
    private final Optional<TagKey<Block>> blacklistedOutputBlockTag;
    private final boolean doubleTallFlower;
    private final boolean sameThroughoutPiece;
    private final int seedRandomAddition;

    public TagReplaceProcessor(Block inputBlock, TagKey<Block> outputBlockTag, Optional<TagKey<Block>> blacklistedOutputBlockTag, boolean doubleTallFlower, boolean sameThroughoutPiece, int seedRandomAddition) {
        this.inputBlock = inputBlock;
        this.outputBlockTag = outputBlockTag;
        this.blacklistedOutputBlockTag = blacklistedOutputBlockTag;
        this.doubleTallFlower = doubleTallFlower;
        this.sameThroughoutPiece = sameThroughoutPiece;
        this.seedRandomAddition = seedRandomAddition;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        StructureTemplate.StructureBlockInfo returnInfo = structureBlockInfoWorld;
        if (structureBlockInfoWorld.state().getBlock() == this.inputBlock) {
            if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.pos())) {
                return structureBlockInfoWorld;
            }
            Optional optionalBlocks = BuiltInRegistries.BLOCK.getTag(this.outputBlockTag);
            if (optionalBlocks.isPresent()) {
                RandomSource randomSource = this.sameThroughoutPiece ? settings.getRandom(pos.above(this.seedRandomAddition)) : settings.getRandom(structureBlockInfoWorld.pos());
                randomSource.nextBoolean();
                List blockList = optionalBlocks.map(holderSet -> holderSet.stream().filter(block -> this.blacklistedOutputBlockTag.map(blockTagKey -> !block.is(blockTagKey)).orElse(true)).map(Holder::value).toList()).orElse(new ArrayList());
                if (this.doubleTallFlower) {
                    blockList = blockList.stream().filter(block -> block instanceof DoublePlantBlock).collect(Collectors.toList());
                }
                if (blockList.size() > 0) {
                    BlockState newBlockState = ((Block)blockList.get(randomSource.nextInt(blockList.size()))).defaultBlockState();
                    for (Property property : structureBlockInfoWorld.state().getProperties()) {
                        if (!newBlockState.hasProperty(property)) continue;
                        newBlockState = GeneralUtils.getStateWithProperty(newBlockState, structureBlockInfoWorld.state(), property);
                    }
                    if (newBlockState.getBlock() instanceof MultifaceBlock) {
                        for (Direction direction : Direction.values()) {
                            BooleanProperty faceProperty = MultifaceBlock.getFaceProperty((Direction)direction);
                            if (!newBlockState.hasProperty((Property)faceProperty)) continue;
                            newBlockState = (BlockState)newBlockState.setValue((Property)faceProperty, (Comparable)Boolean.valueOf(direction == Direction.DOWN));
                        }
                    }
                    if (newBlockState.hasProperty((Property)BlockStateProperties.FLOWER_AMOUNT)) {
                        newBlockState = (BlockState)newBlockState.setValue((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable)Integer.valueOf(4));
                    }
                    if (newBlockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                        newBlockState = (BlockState)newBlockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(!structureBlockInfoWorld.state().getFluidState().isEmpty()));
                    }
                    if (newBlockState.getBlock() instanceof LeavesBlock) {
                        Property property;
                        Optional<Property> optionalProperty = newBlockState.getProperties().stream().filter(p -> p.getName().equalsIgnoreCase("age")).findAny();
                        if (optionalProperty.isPresent() && (property = optionalProperty.get()).getValueClass() == Integer.class) {
                            newBlockState = (BlockState)newBlockState.setValue(property, (Comparable)((Integer)property.getPossibleValues().stream().toArray()[randomSource.nextInt(property.getPossibleValues().size())]));
                        }
                        if (newBlockState.hasProperty((Property)BlockStateProperties.DISTANCE)) {
                            newBlockState = (BlockState)newBlockState.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1));
                        }
                    }
                    ChunkAccess chunk = levelReader.getChunk(structureBlockInfoWorld.pos());
                    BlockPos mainPos = structureBlockInfoWorld.pos();
                    BlockPos groundPos = mainPos.below();
                    BlockState checkingState = newBlockState;
                    BlockState oldTopBlock = null;
                    BlockPos oldTopPos = null;
                    if (this.doubleTallFlower) {
                        if (newBlockState.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER) {
                            oldTopPos = mainPos;
                            mainPos = mainPos.below();
                            groundPos = mainPos.below();
                            checkingState = (BlockState)checkingState.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                        } else {
                            oldTopPos = structureBlockInfoWorld.pos().above();
                        }
                        oldTopBlock = chunk.getBlockState(oldTopPos);
                        chunk.setBlockState(oldTopPos, Blocks.AIR.defaultBlockState(), false);
                    }
                    BlockState oldBlockstate = chunk.getBlockState(mainPos);
                    BlockState belowGroundBlockstate = chunk.getBlockState(groundPos);
                    chunk.setBlockState(mainPos, Blocks.AIR.defaultBlockState(), false);
                    chunk.setBlockState(groundPos, Blocks.GRASS_BLOCK.defaultBlockState(), false);
                    if (checkingState.canSurvive(levelReader, mainPos)) {
                        returnInfo = new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), newBlockState, structureBlockInfoWorld.nbt());
                    }
                    if (oldTopBlock != null) {
                        chunk.setBlockState(oldTopPos, oldTopBlock, false);
                    }
                    chunk.setBlockState(mainPos, oldBlockstate, false);
                    chunk.setBlockState(groundPos, belowGroundBlockstate, false);
                }
            }
        }
        return returnInfo;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.TAG_REPLACE_PROCESSOR.get();
    }
}

