/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.CommonProxy;

public class JadeForgeUtils {
    private JadeForgeUtils() {
    }

    public static ItemIterator<? extends IItemHandler> fromItemHandler(IItemHandler storage, int fromIndex) {
        return JadeForgeUtils.fromItemHandler(storage, fromIndex, CommonProxy::findItemHandler);
    }

    public static ItemIterator<? extends IItemHandler> fromItemHandler(IItemHandler storage, int fromIndex, Function<Accessor<?>, @Nullable IItemHandler> containerFinder) {
        return new ItemIterator.SlottedItemIterator<IItemHandler>(containerFinder, fromIndex){

            @Override
            protected int getSlotCount(IItemHandler container) {
                return container.getSlots();
            }

            @Override
            protected ItemStack getItemInSlot(IItemHandler container, int slot) {
                return container.getStackInSlot(slot);
            }
        };
    }

    public static JadeFluidObject fromFluidStack(FluidStack fluidStack) {
        return JadeFluidObject.of(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getComponentsPatch());
    }

    public static List<ViewGroup<CompoundTag>> fromFluidHandler(IFluidHandler fluidHandler) {
        int maxTanks;
        FluidCollectingResult result = JadeForgeUtils.fromFluidHandlerStream(fluidHandler);
        if (result.tanks == 0) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        int n = maxTanks = result.emptyTanks == 0 ? 5 : 4;
        if (result.tanks - result.emptyTanks <= maxTanks) {
            list.addAll(result.stream.toList());
        } else {
            result.stream.takeWhile(tag -> list.size() <= maxTanks).forEach(tuple1 -> {
                for (Tuple tuple2 : list) {
                    if (!JadeFluidObject.isSameFluidSameComponents((JadeFluidObject)tuple1.getA(), (JadeFluidObject)tuple2.getA())) continue;
                    return;
                }
                list.add(tuple1);
            });
        }
        int remaining = result.tanks - result.emptyTanks - list.size();
        if (result.emptyTanks > 0) {
            list.add(new Tuple((Object)JadeFluidObject.empty(), (Object)result.emptyCapacity));
        }
        ViewGroup<CompoundTag> group = new ViewGroup<CompoundTag>(list.stream().map(tuple -> FluidView.writeDefault((JadeFluidObject)tuple.getA(), (Long)tuple.getB())).toList());
        if (remaining > 0) {
            group.getExtraData().putInt("+", remaining);
        }
        return List.of(group);
    }

    public static FluidCollectingResult fromFluidHandlerStream(IFluidHandler fluidHandler) {
        FluidCollectingResult result = new FluidCollectingResult();
        for (int i2 = 0; i2 < fluidHandler.getTanks(); ++i2) {
            int capacity = fluidHandler.getTankCapacity(i2);
            if (capacity <= 0) continue;
            ++result.tanks;
            if (!fluidHandler.getFluidInTank(i2).isEmpty()) continue;
            ++result.emptyTanks;
            result.emptyCapacity = LongMath.saturatedAdd((long)result.emptyCapacity, (long)capacity);
        }
        result.stream = result.tanks == 0 ? Stream.empty() : IntStream.range(0, fluidHandler.getTanks()).mapToObj(i -> {
            int capacity = fluidHandler.getTankCapacity(i);
            if (capacity <= 0) {
                return null;
            }
            FluidStack fluidStack = fluidHandler.getFluidInTank(i);
            if (fluidStack.isEmpty()) {
                return null;
            }
            return new Tuple((Object)JadeForgeUtils.fromFluidStack(fluidStack), (Object)capacity);
        }).filter(Objects::nonNull);
        return result;
    }

    public static class FluidCollectingResult {
        public Stream<Tuple<JadeFluidObject, Long>> stream;
        public long emptyCapacity;
        public int tanks;
        public int emptyTanks;
    }
}

