/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium._impl.creative.tile;

import com.hrznstudio.titanium._impl.creative.CreativeFEGeneratorBlock;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.PoweredTile;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class CreativeFEGeneratorTile
extends PoweredTile<CreativeFEGeneratorTile> {
    public CreativeFEGeneratorTile(BlockPos pos, BlockState state) {
        super((BasicTileBlock)CreativeFEGeneratorBlock.INSTANCE.getBlock(), (BlockEntityType)CreativeFEGeneratorBlock.INSTANCE.type().get(), pos, state);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, CreativeFEGeneratorTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.getEnergyStorage().receiveEnergy(Integer.MAX_VALUE, false);
        for (Direction direction : Direction.values()) {
            IEnergyStorage iEnergyStorage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.getBlockPos().relative(direction), (Object)direction.getOpposite());
            if (iEnergyStorage == null) continue;
            iEnergyStorage.receiveEnergy(Integer.MAX_VALUE, false);
        }
        this.markForUpdate();
    }

    @Override
    @Nonnull
    public CreativeFEGeneratorTile getSelf() {
        return this;
    }

    @Override
    @ParametersAreNonnullByDefault
    public ItemInteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(player, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION) {
            this.openGui(player);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    @Nonnull
    public EnergyStorageComponent<CreativeFEGeneratorTile> createEnergyStorage() {
        return new EnergyStorageComponent<CreativeFEGeneratorTile>(Integer.MAX_VALUE, 0, 0);
    }
}

