/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.assets.types.ITankAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class TankScreenAddon
extends BasicScreenAddon {
    private IFluidTank tank;
    private ITankAsset asset;
    private FluidTankComponent.Type type;

    public TankScreenAddon(int posX, int posY, IFluidTank tank, FluidTankComponent.Type type) {
        super(posX, posY);
        this.tank = tank;
        this.type = type;
    }

    @Override
    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = IAssetProvider.getAsset(provider, this.type.getAssetType());
        Rectangle area = this.asset.getArea();
        if (!this.tank.getFluid().isEmpty()) {
            TextureAtlasSprite sprite;
            AbstractTexture texture;
            FluidStack fluidStack = this.tank.getFluid();
            double stored = this.tank.getFluidAmount();
            double capacity = this.tank.getCapacity();
            int topBottomPadding = this.asset.getFluidRenderPadding(Direction.UP) + this.asset.getFluidRenderPadding(Direction.DOWN);
            int offset = (int)(stored / capacity * (double)(area.height - topBottomPadding));
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation flowing = renderProperties.getStillTexture(fluidStack);
            if (flowing != null && (texture = screen.getMinecraft().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS)) instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).getSprite(flowing)) != null) {
                Color color = new Color(renderProperties.getTintColor(fluidStack));
                guiGraphics.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
                RenderSystem.enableBlend();
                guiGraphics.blit(this.getPosX() + guiX + this.asset.getFluidRenderPadding(Direction.WEST), this.getPosY() + guiY + this.asset.getFluidRenderPadding(Direction.UP) + (fluidStack.getFluid().is(Tags.Fluids.GASEOUS) ? 0 : area.height - topBottomPadding - offset), 0, (int)(area.getWidth() - (double)this.asset.getFluidRenderPadding(Direction.EAST) - (double)this.asset.getFluidRenderPadding(Direction.WEST)), offset, sprite);
                RenderSystem.disableBlend();
                guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        ITankAsset asset = IAssetProvider.getAsset(provider, this.type.getAssetType());
        AssetUtil.drawAsset(guiGraphics, screen, asset, guiX + this.getPosX(), guiY + this.getPosY());
    }

    @Override
    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public List<Component> getTooltipLines() {
        ArrayList<Component> strings = new ArrayList<Component>();
        strings.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"tooltip.titanium.tank.fluid").getString())).append((Component)(this.tank.getFluid().isEmpty() ? Component.translatable((String)"tooltip.titanium.tank.empty").withStyle(ChatFormatting.WHITE) : Component.translatable((String)this.tank.getFluid().getFluid().getFluidType().getDescriptionId()))).withStyle(ChatFormatting.WHITE));
        strings.add((Component)Component.translatable((String)"tooltip.titanium.tank.amount").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)(String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(this.tank.getFluidAmount()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(this.tank.getCapacity()) + String.valueOf(ChatFormatting.DARK_AQUA) + "mb"))));
        if (!Minecraft.getInstance().player.containerMenu.getCarried().isEmpty() && Minecraft.getInstance().player.containerMenu.getCarried().getCapability(Capabilities.FluidHandler.ITEM) != null) {
            Optional.ofNullable((IFluidHandlerItem)Minecraft.getInstance().player.containerMenu.getCarried().getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(iFluidHandlerItem -> {
                Item carriedItem = Minecraft.getInstance().player.containerMenu.getCarried().getItem();
                boolean isBucket = carriedItem instanceof BucketItem || carriedItem instanceof MilkBucketItem;
                int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                boolean canFillFromItem = false;
                boolean canDrainFromItem = false;
                if (isBucket) {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                    canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                } else {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                    boolean bl = canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                }
                if (canFillFromItem) {
                    strings.add((Component)Component.translatable((String)"tooltip.titanium.tank.can_fill_from_item").withStyle(ChatFormatting.BLUE));
                }
                if (canDrainFromItem) {
                    strings.add((Component)Component.translatable((String)"tooltip.titanium.tank.can_drain_from_item").withStyle(ChatFormatting.GOLD));
                }
                if (canFillFromItem) {
                    strings.add((Component)Component.translatable((String)"tooltip.titanium.tank.action_fill").withStyle(ChatFormatting.DARK_GRAY));
                }
                if (canDrainFromItem) {
                    strings.add((Component)Component.translatable((String)"tooltip.titanium.tank.action_drain").withStyle(ChatFormatting.DARK_GRAY));
                }
                if (!canDrainFromItem && !canFillFromItem) {
                    strings.add((Component)Component.translatable((String)"tooltip.titanium.tank.no_action").withStyle(ChatFormatting.RED));
                }
            });
        } else {
            strings.add((Component)Component.translatable((String)"tooltip.titanium.tank.no_tank").withStyle(ChatFormatting.DARK_GRAY));
        }
        return strings;
    }

    @Override
    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Screen screen;
        if (!Minecraft.getInstance().player.containerMenu.getCarried().isEmpty() && Minecraft.getInstance().player.containerMenu.getCarried().getCapability(Capabilities.FluidHandler.ITEM) != null && (screen = Minecraft.getInstance().screen) instanceof AbstractContainerScreen && ((AbstractContainerScreen)screen).getMenu() instanceof ILocatable) {
            if (!this.isMouseOver(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 1.0f, 1.0f, RandomSource.create(), Minecraft.getInstance().player.blockPosition()));
            ILocatable locatable = (ILocatable)((AbstractContainerScreen)screen).getMenu();
            CompoundTag compoundNBT = new CompoundTag();
            if (this.tank instanceof FluidTankComponent) {
                compoundNBT.putString("Name", ((FluidTankComponent)this.tank).getName());
            } else {
                compoundNBT.putBoolean("Invalid", true);
            }
            Optional.ofNullable((IFluidHandlerItem)Minecraft.getInstance().player.containerMenu.getCarried().getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(iFluidHandlerItem -> {
                Item carriedItem = Minecraft.getInstance().player.containerMenu.getCarried().getItem();
                boolean isBucket = carriedItem instanceof BucketItem || carriedItem instanceof MilkBucketItem;
                int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                boolean canFillFromItem = false;
                boolean canDrainFromItem = false;
                if (isBucket) {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                    canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                } else {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                    boolean bl = canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                }
                if (canFillFromItem && button == 0) {
                    compoundNBT.putBoolean("Fill", true);
                }
                if (canDrainFromItem && button == 1) {
                    compoundNBT.putBoolean("Fill", false);
                }
            });
            Titanium.NETWORK.sendToServer(new ButtonClickNetworkMessage(locatable.getLocatorInstance(), -3, compoundNBT));
            return true;
        }
        return false;
    }
}

