/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.command;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.reward.RewardSyncMessage;
import com.hrznstudio.titanium.reward.storage.RewardWorldStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class RewardCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"titanium-rewards").then(Commands.argument((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])new String[]{"enable", "disable"}, (SuggestionsBuilder)builder)).then(Commands.argument((String)"reward", (ArgumentType)new ResourceLocationArgument()).suggests((context, builder) -> SharedSuggestionProvider.suggest(RewardCommand.getAvailableResourceLocations((CommandContext<CommandSourceStack>)context).stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).then(Commands.argument((String)"option", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])RewardManager.get().getReward((ResourceLocation)context.getArgument("reward", ResourceLocation.class)).getOptions(), (SuggestionsBuilder)builder)).executes(context -> {
            RewardCommand.execute((CommandContext<CommandSourceStack>)context);
            return 1;
        })))));
    }

    private static void execute(CommandContext<CommandSourceStack> context) {
        boolean changed = false;
        changed = ((String)context.getArgument("action", String.class)).equalsIgnoreCase("enable") ? RewardCommand.addReward(context) : RewardCommand.removeReward(context);
        if (changed) {
            ((CommandSourceStack)context.getSource()).getServer().execute(() -> {
                CompoundTag nbt = RewardWorldStorage.get(((CommandSourceStack)context.getSource()).getServer().getLevel(Level.OVERWORLD)).serializeSimple((HolderLookup.Provider)((CommandSourceStack)context.getSource()).getServer().registryAccess());
                ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers().forEach(serverPlayerEntity -> Titanium.NETWORK.sendTo(new RewardSyncMessage(nbt), (ServerPlayer)serverPlayerEntity));
            });
        }
    }

    private static boolean removeReward(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(source.getLevel());
        try {
            rewardWorldStorage.remove(source.getPlayerOrException().getUUID(), (ResourceLocation)context.getArgument("reward", ResourceLocation.class));
            rewardWorldStorage.setDirty();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"titanium.rewards.remove_success"), true);
            return true;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean addReward(CommandContext<CommandSourceStack> context) {
        try {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ResourceLocation resourceLocation = (ResourceLocation)context.getArgument("reward", ResourceLocation.class);
            if (RewardManager.get().getReward(resourceLocation) == null || !RewardManager.get().getReward(resourceLocation).isPlayerValid(source.getPlayerOrException().getUUID())) {
                return false;
            }
            RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(source.getLevel());
            String option = (String)context.getArgument("option", String.class);
            if (!Arrays.asList(RewardManager.get().getReward(resourceLocation).getOptions()).contains(option)) {
                return false;
            }
            rewardWorldStorage.add(source.getPlayerOrException().getUUID(), (ResourceLocation)context.getArgument("reward", ResourceLocation.class), option);
            rewardWorldStorage.setDirty();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"titanium.rewards.enabled_success"), true);
            return true;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static List<ResourceLocation> getAvailableResourceLocations(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(source.getLevel());
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>(rewardWorldStorage.getFreeRewards());
        try {
            resourceLocations.addAll(RewardManager.get().collectRewardsResourceLocations(((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID()));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return resourceLocations;
    }
}

