/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.component.sideness;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.util.FacingUtil;
import java.awt.Rectangle;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public interface IFacingComponent {
    public Map<FacingUtil.Sideness, FaceMode> getFacingModes();

    public int getColor();

    public Rectangle getRectangle(IAsset var1);

    public String getName();

    public int getFacingHandlerX();

    public int getFacingHandlerY();

    public boolean work(Level var1, BlockPos var2, Direction var3, int var4);

    public IFacingComponent setFacingHandlerPos(int var1, int var2);

    public FaceMode[] getValidFacingModes();

    public static enum FaceMode {
        NONE(false, 0, AssetTypes.BUTTON_SIDENESS_DISABLED, ChatFormatting.RED),
        ENABLED(true, 1, AssetTypes.BUTTON_SIDENESS_ENABLED, ChatFormatting.GREEN),
        PUSH(true, 2, AssetTypes.BUTTON_SIDENESS_PUSH, ChatFormatting.YELLOW),
        PULL(true, 3, AssetTypes.BUTTON_SIDENESS_PULL, ChatFormatting.BLUE);

        private final boolean allowsConnection;
        private final int index;
        private final IAssetType<?> assetType;
        private final ChatFormatting color;

        private FaceMode(boolean allowsConnection, int index, IAssetType<?> assetType, ChatFormatting color) {
            this.allowsConnection = allowsConnection;
            this.index = index;
            this.assetType = assetType;
            this.color = color;
        }

        public boolean allowsConnection() {
            return this.allowsConnection;
        }

        public StateButtonInfo getInfo(int index) {
            return new StateButtonInfo(index, this.assetType, "tooltip.titanium.facing_handler." + this.name().toLowerCase());
        }

        public int getIndex() {
            return this.index;
        }

        public ChatFormatting getColor() {
            return this.color;
        }
    }
}

