/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import com.hrznstudio.titanium.Titanium;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class AnnotationUtil {
    public static List<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
        ArrayList classList = new ArrayList();
        Type type = Type.getType(annotation);
        for (ModFileScanData allScanDatum : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData allScanDatumAnnotation : allScanDatum.getAnnotations()) {
                if (!Objects.equals(allScanDatumAnnotation.annotationType(), type)) continue;
                try {
                    classList.add(Class.forName(allScanDatumAnnotation.memberName()));
                }
                catch (ClassNotFoundException e) {
                    Titanium.LOGGER.error((Object)e);
                }
            }
        }
        return classList;
    }

    public static List<Class<?>> getFilteredAnnotatedClasses(Class<? extends Annotation> annotation, String filter) {
        ArrayList classList = new ArrayList();
        Type type = Type.getType(annotation);
        for (ModFileScanData.AnnotationData allScanDatumAnnotation : ModList.get().getModFileById(filter).getFile().getScanResult().getAnnotations()) {
            if (!Objects.equals(allScanDatumAnnotation.annotationType(), type)) continue;
            try {
                classList.add(Class.forName(allScanDatumAnnotation.memberName()));
            }
            catch (ClassNotFoundException e) {
                Titanium.LOGGER.error((Object)e);
            }
        }
        return classList;
    }

    public static List<Field> getAnnotatedFields(Class<? extends Annotation> annotation) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Type type = Type.getType(annotation);
        for (ModFileScanData allScanDatum : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotationData : allScanDatum.getAnnotations()) {
                if (!Objects.equals(annotationData.annotationType(), type)) continue;
                try {
                    for (Field field : Class.forName(annotationData.clazz().getClassName()).getDeclaredFields()) {
                        if (!field.getName().equalsIgnoreCase(annotationData.memberName())) continue;
                        fields.add(field);
                    }
                }
                catch (ClassNotFoundException e) {
                    Titanium.LOGGER.error((Object)e);
                }
            }
        }
        return fields;
    }
}

